/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.query;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.engine.SearchEngineQueryParseException;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.util.LuceneQueryParser;

public class LuceneSearchEngineQueryStringBuilder
implements SearchEngineQueryBuilder.SearchEngineQueryStringBuilder {
    private LuceneSearchEngine searchEngine;
    private Analyzer analyzer;
    private String defaultSearchProperty;
    private String queryString;
    private QueryParser.Operator operator = QueryParser.Operator.OR;

    public LuceneSearchEngineQueryStringBuilder(LuceneSearchEngine searchEngine, String queryString) {
        this.searchEngine = searchEngine;
        this.queryString = queryString;
        this.analyzer = searchEngine.getSearchEngineFactory().getAnalyzerManager().getSearchAnalyzer();
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder setAnalyzer(String analyzer) {
        this.analyzer = this.searchEngine.getSearchEngineFactory().getAnalyzerManager().getAnalyzerMustExist(analyzer);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder setAnalyzerByAlias(String alias) {
        this.analyzer = this.searchEngine.getSearchEngineFactory().getAnalyzerManager().getAnalyzerByAliasMustExists(alias);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder setDefaultSearchProperty(String defaultSearchProperty) {
        this.defaultSearchProperty = defaultSearchProperty;
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder useAndDefaultOperator() {
        this.operator = QueryParser.Operator.AND;
        return this;
    }

    public SearchEngineQuery toQuery() {
        Query qQuery;
        String defaultSearch = this.defaultSearchProperty;
        if (defaultSearch == null) {
            defaultSearch = this.searchEngine.getSearchEngineFactory().getLuceneSettings().getDefaultSearchPropery();
        }
        try {
            LuceneQueryParser queryParser = new LuceneQueryParser(defaultSearch, this.analyzer);
            queryParser.setDefaultOperator(this.operator);
            qQuery = queryParser.parse(this.queryString);
        }
        catch (ParseException e) {
            throw new SearchEngineQueryParseException(this.queryString, e);
        }
        return new LuceneSearchEngineQuery(this.searchEngine, qQuery);
    }
}

