/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LuceneUtils;
import org.apache.lucene.store.Directory;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.event.SearchEngineEventManager;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;
import org.compass.core.lucene.engine.store.LuceneStoreTemplate;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.util.StringUtils;

public abstract class AbstractLuceneSearchEngineStore
implements LuceneSearchEngineStore {
    protected Log log = LogFactory.getLog(this.getClass());
    private Map aliasBySubIndex = new HashMap();
    private Map subIndexByAlias = new HashMap();
    private String[] subIndexes;
    protected LuceneStoreTemplate template;
    protected String connectionString;
    protected String subContext;
    private LuceneSettings luceneSettings;

    public AbstractLuceneSearchEngineStore(String connectionString, String subContext) {
        this.connectionString = connectionString;
        this.subContext = subContext;
    }

    public void configure(LuceneSearchEngineFactory searchEngineFactory, CompassSettings settings, CompassMapping mapping) {
        this.template = new LuceneStoreTemplate(this);
        this.luceneSettings = searchEngineFactory.getLuceneSettings();
        HashSet<String> subIndexesSet = new HashSet<String>();
        ResourceMapping[] rootMappings = mapping.getRootMappings();
        for (int i = 0; i < rootMappings.length; ++i) {
            ResourceMapping resourceMapping = rootMappings[i];
            String subIndex = resourceMapping.getSubIndex();
            String alias = resourceMapping.getAlias();
            this.aliasBySubIndex.put(alias, subIndex);
            subIndexesSet.add(subIndex);
            ArrayList<String> list = (ArrayList<String>)this.subIndexByAlias.get(subIndex);
            if (this.subIndexByAlias.get(subIndex) == null) {
                list = new ArrayList<String>();
                this.subIndexByAlias.put(subIndex, list);
            }
            list.add(alias);
        }
        this.subIndexes = subIndexesSet.toArray(new String[subIndexesSet.size()]);
    }

    public void close() {
        this.doClose();
    }

    protected void doClose() {
    }

    public void performScheduledTasks() {
    }

    public void closeDirectory(Directory dir) throws SearchEngineException {
        try {
            if (dir != null) {
                dir.close();
            }
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to close directory store", e);
        }
    }

    public String getSubIndexForAlias(String alias) {
        return (String)this.aliasBySubIndex.get(alias);
    }

    public int getNumberOfAliasesByAlias(String alias) {
        return this.getNumberOfAliasesBySubIndex(this.getSubIndexForAlias(alias));
    }

    public int getNumberOfAliasesBySubIndex(String subIndex) {
        return ((ArrayList)this.subIndexByAlias.get(subIndex)).size();
    }

    public Directory getDirectoryByAlias(String alias, boolean create) throws SearchEngineException {
        return this.doGetDirectoryForPath(this.getSubIndexForAlias(alias), create);
    }

    public Directory getDirectoryBySubIndex(String subIndex, boolean create) throws SearchEngineException {
        return this.doGetDirectoryForPath(subIndex, create);
    }

    protected abstract Directory doGetDirectoryForPath(String var1, boolean var2) throws SearchEngineException;

    private void createIndex(String subIndex) throws SearchEngineException {
        this.template.executeForSubIndex(subIndex, true, new LuceneSearchEngineStore.LuceneStoreCallback(){

            public Object doWithStore(Directory dir) throws IOException {
                IndexWriter indexWriter = new IndexWriter(dir, (Analyzer)new StandardAnalyzer(), true);
                indexWriter.close();
                return null;
            }
        });
    }

    protected boolean indexExists(String subIndex) throws SearchEngineException {
        try {
            Boolean retVal = (Boolean)this.template.executeForSubIndex(subIndex, false, new LuceneSearchEngineStore.LuceneStoreCallback(){

                public Object doWithStore(Directory dir) throws IOException {
                    return AbstractLuceneSearchEngineStore.this.indexExists(dir);
                }
            });
            return retVal;
        }
        catch (SearchEngineException e) {
            return false;
        }
    }

    protected Boolean indexExists(Directory dir) throws IOException {
        if (!IndexReader.indexExists((Directory)dir)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected boolean verifyIndex(String subIndex) throws SearchEngineException {
        if (!this.indexExists(subIndex)) {
            this.createIndex(subIndex);
            return true;
        }
        return false;
    }

    public void createIndex() throws SearchEngineException {
        for (int i = 0; i < this.subIndexes.length; ++i) {
            this.createIndex(this.subIndexes[i]);
        }
    }

    public boolean verifyIndex() throws SearchEngineException {
        boolean createdIndex = false;
        for (int i = 0; i < this.subIndexes.length; ++i) {
            if (!this.verifyIndex(this.subIndexes[i])) continue;
            createdIndex = true;
        }
        return createdIndex;
    }

    public boolean indexExists() throws SearchEngineException {
        for (int i = 0; i < this.subIndexes.length; ++i) {
            if (this.indexExists(this.subIndexes[i])) continue;
            return false;
        }
        return true;
    }

    public String[] getSubIndexes() {
        return this.subIndexes;
    }

    public String[] calcSubIndexes(String[] subIndexes, String[] aliases) {
        int i;
        if (aliases == null) {
            if (subIndexes == null) {
                return this.getSubIndexes();
            }
            return subIndexes;
        }
        HashSet<String> ret = new HashSet<String>();
        for (i = 0; i < aliases.length; ++i) {
            String subIndex = this.getSubIndexForAlias(aliases[i]);
            if (subIndex == null) {
                throw new IllegalArgumentException("No sub-index is mapped to alias [" + aliases[i] + "]");
            }
            ret.add(subIndex);
        }
        if (subIndexes != null) {
            for (i = 0; i < subIndexes.length; ++i) {
                ret.add(subIndexes[i]);
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    public boolean isLocked(String subIndex) throws SearchEngineException {
        Boolean retVal = (Boolean)this.template.executeForSubIndex(subIndex, false, new LuceneSearchEngineStore.LuceneStoreCallback(){

            public Object doWithStore(Directory dir) throws IOException {
                return IndexReader.isLocked((Directory)dir);
            }
        });
        return retVal;
    }

    public void registerEventListeners(SearchEngine searchEngine, SearchEngineEventManager eventManager) {
    }

    public void copyFrom(final LuceneSearchEngineStore searchEngineStore) throws SearchEngineException {
        CopyFromHolder holder = this.doBeforeCopyFrom();
        final byte[] buffer = new byte[32768];
        try {
            for (int i = 0; i < this.getSubIndexes().length; ++i) {
                final String subIndex = this.getSubIndexes()[i];
                this.template.executeForSubIndex(subIndex, holder.createOriginalDirectory, new LuceneSearchEngineStore.LuceneStoreCallback(){

                    public Object doWithStore(final Directory dest) {
                        final Directory src = searchEngineStore.getDirectoryBySubIndex(subIndex, false);
                        AbstractLuceneSearchEngineStore.this.template.execute(src, new LuceneSearchEngineStore.LuceneStoreCallback(){

                            public Object doWithStore(Directory dir) throws IOException {
                                LuceneUtils.copy(src, searchEngineStore.getLuceneSettings().isUseCompoundFile(), dest, AbstractLuceneSearchEngineStore.this.luceneSettings.isUseCompoundFile(), buffer, AbstractLuceneSearchEngineStore.this.luceneSettings.getTransactionCommitTimeout());
                                return null;
                            }
                        });
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            this.doAfterFailedCopyFrom(holder);
            if (e instanceof SearchEngineException) {
                throw (SearchEngineException)e;
            }
            throw new SearchEngineException("Failed to copy from " + searchEngineStore, e);
        }
        this.doAfterSuccessfulCopyFrom(holder);
    }

    protected CopyFromHolder doBeforeCopyFrom() throws SearchEngineException {
        CopyFromHolder holder = new CopyFromHolder();
        holder.createOriginalDirectory = false;
        return holder;
    }

    protected void doAfterSuccessfulCopyFrom(CopyFromHolder holder) throws SearchEngineException {
    }

    protected void doAfterFailedCopyFrom(CopyFromHolder holder) throws SearchEngineException {
    }

    public LuceneSettings getLuceneSettings() {
        return this.luceneSettings;
    }

    public String toString() {
        return "store [" + this.connectionString + "][" + this.subContext + "] sub-indexes [" + StringUtils.arrayToCommaDelimitedString(this.subIndexes) + "]";
    }

    protected class CopyFromHolder {
        boolean createOriginalDirectory = false;
        Object data;

        protected CopyFromHolder() {
        }
    }
}

