/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.store.AbstractLuceneSearchEngineStore;
import org.compass.core.lucene.util.LuceneUtils;
import org.compass.core.mapping.CompassMapping;

public class FSLuceneSearchEngineStore
extends AbstractLuceneSearchEngineStore {
    private String indexPath;

    public FSLuceneSearchEngineStore(String indexPath, String subContext) {
        super(indexPath, subContext);
        this.indexPath = indexPath + "/" + subContext;
    }

    public void configure(LuceneSearchEngineFactory searchEngineFactory, CompassSettings settings, CompassMapping mapping) {
        FSDirectory directory;
        System.setProperty("org.apache.lucene.FSDirectory.class", this.getFSDirectoryClass());
        try {
            directory = FSDirectory.getDirectory((String)System.getProperty("java.io.tmpdir"), (boolean)false);
            directory.close();
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to open the lucene directory", e);
        }
        if (!directory.getClass().getName().equals(this.getFSDirectoryClass())) {
            throw new SearchEngineException("Setting type of FS directory is a JVM level setting, you can not set different values within the same JVM");
        }
        super.configure(searchEngineFactory, settings, mapping);
    }

    protected String getFSDirectoryClass() {
        return "org.apache.lucene.store.FSDirectory";
    }

    protected Directory doGetDirectoryForPath(String path, boolean create) throws SearchEngineException {
        try {
            return FSDirectory.getDirectory((String)(this.indexPath + "/" + path), (boolean)create);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to open directory for path [" + path + "]", e);
        }
    }

    public void deleteIndex() throws SearchEngineException {
        boolean deleted;
        File indexPathFile = new File(this.indexPath);
        if (indexPathFile.exists() && !(deleted = LuceneUtils.deleteDir(indexPathFile))) {
            throw new SearchEngineException("Failed to delete index directory [" + this.indexPath + "]");
        }
    }

    protected AbstractLuceneSearchEngineStore.CopyFromHolder doBeforeCopyFrom() throws SearchEngineException {
        File renameToIndexPathFile;
        File indexPathFile = new File(this.indexPath);
        int count = 0;
        while ((renameToIndexPathFile = new File(this.indexPath + "copy" + count++)).exists()) {
        }
        if (!indexPathFile.renameTo(renameToIndexPathFile)) {
            throw new SearchEngineException("Failed to rename index [" + this.indexPath + "] to [" + renameToIndexPathFile.getPath() + "]");
        }
        AbstractLuceneSearchEngineStore.CopyFromHolder holder = new AbstractLuceneSearchEngineStore.CopyFromHolder();
        holder.createOriginalDirectory = true;
        holder.data = renameToIndexPathFile;
        return holder;
    }

    protected void doAfterSuccessfulCopyFrom(AbstractLuceneSearchEngineStore.CopyFromHolder holder) throws SearchEngineException {
        File renameToIndexPathFile = (File)holder.data;
        try {
            LuceneUtils.deleteDir(renameToIndexPathFile);
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to delete backup directory", (Throwable)e);
        }
    }

    protected void doAfterFailedCopyFrom(Object holder) throws SearchEngineException {
    }
}

