/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Directory;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;

public class LuceneStoreTemplate {
    private static Log log = LogFactory.getLog((Class)LuceneStoreTemplate.class);
    private LuceneSearchEngineStore searchEngineStore;

    public LuceneStoreTemplate(LuceneSearchEngineStore searchEngineStore) {
        this.searchEngineStore = searchEngineStore;
    }

    public Object executeForSubIndex(String subIndex, boolean create, LuceneSearchEngineStore.LuceneStoreCallback callback) throws SearchEngineException {
        Directory dir = this.searchEngineStore.getDirectoryBySubIndex(subIndex, create);
        return this.execute(dir, callback);
    }

    public Object executeForAlias(String alias, boolean create, LuceneSearchEngineStore.LuceneStoreCallback callback) throws SearchEngineException {
        Directory dir = this.searchEngineStore.getDirectoryByAlias(alias, create);
        return this.execute(dir, callback);
    }

    public Object execute(Directory dir, LuceneSearchEngineStore.LuceneStoreCallback callback) throws SearchEngineException {
        Exception ex = null;
        try {
            return callback.doWithStore(dir);
        }
        catch (Exception e) {
            block8: {
                ex = e;
                try {
                    if (dir != null) {
                        dir.close();
                    }
                }
                catch (Exception e2) {
                    if (ex == null) {
                        ex = e2;
                        break block8;
                    }
                    log.warn((Object)"Caught an exception trying to close the lucene directory with other exception pending, logging and ignoring", (Throwable)e2);
                }
            }
            if (ex != null) {
                if (ex instanceof SearchEngineException) {
                    throw (SearchEngineException)ex;
                }
                throw new SearchEngineException("Failed while executing a lucene directory based operation", ex);
            }
            return null;
        }
    }
}

