/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store.jdbc;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.compass.core.CompassException;
import org.compass.core.config.CompassSettings;
import org.compass.core.lucene.engine.store.jdbc.AbstractDataSourceProvider;

public class DbcpDataSourceProvider
extends AbstractDataSourceProvider {
    protected DataSource doCreateDataSource(String url, CompassSettings settings) throws CompassException {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDefaultAutoCommit(this.autoCommit);
        dataSource.setDriverClassName(this.driverClass);
        dataSource.setUrl(url);
        dataSource.setUsername(this.username);
        dataSource.setPassword(this.password);
        if (settings.getSetting("compass.engine.store.jdbc.connection.provider.dbcp.defaultTransactionIsolation") != null) {
            dataSource.setDefaultTransactionIsolation(settings.getSettingAsInt("compass.engine.store.jdbc.connection.provider.dbcp.defaultTransactionIsolation", 0));
        }
        if (settings.getSetting("compass.engine.store.jdbc.connection.provider.dbcp.initialSize") != null) {
            dataSource.setInitialSize(settings.getSettingAsInt("compass.engine.store.jdbc.connection.provider.dbcp.initialSize", 0));
        }
        if (settings.getSetting("compass.engine.store.jdbc.connection.provider.dbcp.maxActive") != null) {
            dataSource.setMaxActive(settings.getSettingAsInt("compass.engine.store.jdbc.connection.provider.dbcp.maxActive", 0));
        }
        if (settings.getSetting("compass.engine.store.jdbc.connection.provider.dbcp.maxIdle") != null) {
            dataSource.setMaxIdle(settings.getSettingAsInt("compass.engine.store.jdbc.connection.provider.dbcp.maxIdle", 0));
        }
        if (settings.getSetting("compass.engine.store.jdbc.connection.provider.dbcp.minIdle") != null) {
            dataSource.setMinIdle(settings.getSettingAsInt("compass.engine.store.jdbc.connection.provider.dbcp.minIdle", 0));
        }
        if (settings.getSetting("compass.engine.store.jdbc.connection.provider.dbcp.maxWait") != null) {
            dataSource.setMaxWait(settings.getSettingAsLong("compass.engine.store.jdbc.connection.provider.dbcp.maxWait", 0L));
        }
        if (settings.getSetting("compass.engine.store.jdbc.connection.provider.dbcp.maxOpenPreparedStatements") != null) {
            dataSource.setMaxOpenPreparedStatements(settings.getSettingAsInt("compass.engine.store.jdbc.connection.provider.dbcp.maxOpenPreparedStatements", 0));
        }
        if (settings.getSetting("compass.engine.store.jdbc.connection.provider.dbcp.poolPreparedStatements") != null) {
            dataSource.setPoolPreparedStatements(settings.getSettingAsBoolean("compass.engine.store.jdbc.connection.provider.dbcp.poolPreparedStatements", false));
        }
        return dataSource;
    }

    public void closeDataSource() {
        try {
            ((BasicDataSource)this.getDataSource()).close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

