/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.lucene.store.jdbc.datasource.AbstractDataSource;
import org.compass.core.CompassException;
import org.compass.core.config.CompassSettings;
import org.compass.core.jndi.NamingHelper;
import org.compass.core.lucene.engine.store.jdbc.AbstractDataSourceProvider;

public class JndiDataSourceProvider
extends AbstractDataSourceProvider {
    protected DataSource doCreateDataSource(String url, CompassSettings settings) throws CompassException {
        try {
            DataSource dataSource = (DataSource)NamingHelper.getInitialContext(settings).lookup(url);
            return new UsernamePasswordDataSourceWrapper(dataSource, this.username, this.password, this.autoCommit);
        }
        catch (NamingException e) {
            throw new CompassException("Failed to lookup data source from jndi under [" + url + "]", e);
        }
    }

    private static class UsernamePasswordDataSourceWrapper
    extends AbstractDataSource {
        private DataSource dataSource;
        private String username;
        private String password;
        private boolean autoCommit;

        public UsernamePasswordDataSourceWrapper(DataSource dataSource, String username, String password, boolean autoCommit) {
            this.dataSource = dataSource;
            this.username = username;
            this.password = password;
            this.autoCommit = autoCommit;
        }

        public Connection getConnection() throws SQLException {
            return this.getConnection(this.username, this.password);
        }

        public Connection getConnection(String username, String password) throws SQLException {
            Connection conn = username == null ? this.dataSource.getConnection() : this.dataSource.getConnection(username, password);
            if (conn.getAutoCommit() != this.autoCommit) {
                conn.setAutoCommit(this.autoCommit);
            }
            return conn;
        }
    }
}

