/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction;

import java.util.ArrayList;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineHighlighter;
import org.compass.core.engine.SearchEngineHits;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.lucene.engine.LuceneDelegatedClose;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerManager;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.transaction.LuceneSearchEngineTransaction;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;

public abstract class AbstractTransaction
implements LuceneSearchEngineTransaction {
    private LuceneSearchEngine searchEngine;
    private LuceneSearchEngineIndexManager indexManager;
    private CompassMapping mapping;
    private LuceneAnalyzerManager analyzerManager;
    private ArrayList delegateClose = new ArrayList();
    protected boolean dirty;

    public void configure(LuceneSearchEngine searchEngine) {
        this.searchEngine = searchEngine;
        this.indexManager = searchEngine.getSearchEngineFactory().getLuceneIndexManager();
        this.mapping = searchEngine.getSearchEngineFactory().getMapping();
        this.analyzerManager = searchEngine.getSearchEngineFactory().getAnalyzerManager();
    }

    public void begin() throws SearchEngineException {
        this.closeHits();
        this.doBegin();
    }

    protected abstract void doBegin() throws SearchEngineException;

    public void rollback() throws SearchEngineException {
        this.closeHits();
        this.doRollback();
    }

    protected abstract void doRollback() throws SearchEngineException;

    public void prepare() throws SearchEngineException {
        this.doPrepare();
    }

    protected abstract void doPrepare() throws SearchEngineException;

    public void commit(boolean onePhase) throws SearchEngineException {
        this.closeHits();
        this.doCommit(onePhase);
    }

    protected abstract void doCommit(boolean var1) throws SearchEngineException;

    public SearchEngineHits find(SearchEngineQuery query) throws SearchEngineException {
        SearchEngineHits hits = this.doFind((LuceneSearchEngineQuery)query);
        this.delegateClose.add(hits);
        return hits;
    }

    protected abstract SearchEngineHits doFind(LuceneSearchEngineQuery var1) throws SearchEngineException;

    public SearchEngineHighlighter highlighter(SearchEngineQuery query) throws SearchEngineException {
        SearchEngineHighlighter highlighter = this.doHighlighter((LuceneSearchEngineQuery)query);
        this.delegateClose.add(highlighter);
        return highlighter;
    }

    protected abstract SearchEngineHighlighter doHighlighter(LuceneSearchEngineQuery var1) throws SearchEngineException;

    public void create(Resource resource) throws SearchEngineException {
        this.dirty = true;
        this.doCreate(resource);
    }

    protected abstract void doCreate(Resource var1) throws SearchEngineException;

    public void delete(Property[] ids, String alias) throws SearchEngineException {
        this.dirty = true;
        this.doDelete(ids, alias);
    }

    protected abstract void doDelete(Property[] var1, String var2) throws SearchEngineException;

    public boolean isDirty() {
        return this.dirty;
    }

    protected void closeHits() throws SearchEngineException {
        for (int i = 0; i < this.delegateClose.size(); ++i) {
            try {
                ((LuceneDelegatedClose)this.delegateClose.get(i)).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.delegateClose.clear();
    }

    protected ResourceMapping getResourceMapping(String alias) {
        return this.mapping.getRootMappingByAlias(alias);
    }

    public LuceneSearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    public LuceneSearchEngineIndexManager getIndexManager() {
        return this.indexManager;
    }

    public CompassMapping getMapping() {
        return this.mapping;
    }

    public LuceneAnalyzerManager getAnalyzerManager() {
        return this.analyzerManager;
    }
}

