/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineHighlighter;
import org.compass.core.engine.SearchEngineHits;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.LuceneTermInfoVector;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.transaction.AbstractTransaction;
import org.compass.core.lucene.util.LuceneUtils;

public class BatchInsertTransaction
extends AbstractTransaction {
    private WriterManager writerManager;

    protected void doBegin() throws SearchEngineException {
        this.writerManager = new WriterManager(this.getIndexManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRollback() throws SearchEngineException {
        try {
            this.writerManager.closeIndexWriters(true, true);
        }
        finally {
            this.writerManager.clear();
        }
        throw new SearchEngineException("Rollback operation not supported for batch insert transaction");
    }

    protected void doPrepare() throws SearchEngineException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit(boolean onePhase) throws SearchEngineException {
        try {
            this.writerManager.closeIndexWriters(true, true);
            this.getIndexManager().clearCache();
        }
        finally {
            this.writerManager.clear();
        }
        if (!onePhase) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws SearchEngineException {
        try {
            this.writerManager.closeIndexWriters(true, true);
        }
        finally {
            this.writerManager.clear();
        }
    }

    protected void doCreate(Resource resource) throws SearchEngineException {
        WriterManager.IndexWriterWrapper wrapper = this.writerManager.openWriterByAlias(resource.getAlias());
        Analyzer analyzer = this.getAnalyzerManager().getAnalyzerByResource(resource);
        LuceneUtils.createResource(wrapper.indexWriter, resource, analyzer);
    }

    protected void doDelete(Property[] ids, String alias) throws SearchEngineException {
        throw new SearchEngineException("Delete operation not supported for batch insert transaction");
    }

    protected SearchEngineHits doFind(LuceneSearchEngineQuery query) throws SearchEngineException {
        throw new SearchEngineException("Find operation not supported for batch insert transaction");
    }

    public Resource[] find(Property[] ids, String alias) throws SearchEngineException {
        throw new SearchEngineException("Find operation not supported for batch insert transaction");
    }

    protected SearchEngineHighlighter doHighlighter(LuceneSearchEngineQuery query) throws SearchEngineException {
        throw new SearchEngineException("Highlighter not supported for batch insert transaction");
    }

    public LuceneTermInfoVector getTermInfo(LuceneResource resource, String propertyName) {
        throw new SearchEngineException("Term info not supported for batch insert transaction");
    }

    public LuceneTermInfoVector[] getTermInfos(LuceneResource resource) {
        throw new SearchEngineException("Term info not supported for batch insert transaction");
    }

    public static class WriterManager {
        private HashMap writersMap = new HashMap();
        private ArrayList writers = new ArrayList();
        private LuceneSearchEngineIndexManager indexManager;

        public WriterManager(LuceneSearchEngineIndexManager indexManager) {
            this.indexManager = indexManager;
        }

        public boolean hasWriterForSubIndex(String subIndex) {
            return this.writersMap.get(subIndex) != null;
        }

        public IndexWriterWrapper getWriterForSubIndex(String subIndex) {
            return (IndexWriterWrapper)this.writersMap.get(subIndex);
        }

        public int size() {
            return this.writers.size();
        }

        public void clear() {
            this.writers.clear();
            this.writersMap.clear();
        }

        public IndexWriterWrapper openWriterByAlias(String alias) throws SearchEngineException {
            String subIndex = this.indexManager.getStore().getSubIndexForAlias(alias);
            IndexWriterWrapper wrapper = (IndexWriterWrapper)this.writersMap.get(subIndex);
            if (wrapper == null) {
                wrapper = new IndexWriterWrapper();
                wrapper.subIndex = subIndex;
                wrapper.dir = this.indexManager.getStore().getDirectoryBySubIndex(subIndex, false);
                this.writers.add(wrapper);
                this.writersMap.put(subIndex, wrapper);
                try {
                    wrapper.indexWriter = this.indexManager.openIndexWriter(wrapper.dir, false);
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to open index writer for alias [" + alias + "] and sub-index [" + subIndex + "]", e);
                }
            }
            return wrapper;
        }

        private void closeIndexWriter(IndexWriterWrapper writer) throws SearchEngineException {
            if (writer != null && writer.indexWriter != null) {
                try {
                    writer.indexWriter.close();
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to close index writer for sub-index [" + writer.subIndex + "]", e);
                }
                finally {
                    writer.indexWriter = null;
                }
            }
        }

        private void optimizeIndexWriter(IndexWriterWrapper writer) throws SearchEngineException {
            if (writer != null && writer.indexWriter != null) {
                try {
                    writer.indexWriter.optimize();
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to optimize index writer for sub-index [" + writer.subIndex + "]", e);
                }
            }
        }

        public void closeIndexWriters(boolean withDirs, boolean withOptimize) throws SearchEngineException {
            Exception e = null;
            for (int i = 0; i < this.writers.size(); ++i) {
                IndexWriterWrapper writer = (IndexWriterWrapper)this.writers.get(i);
                try {
                    if (withOptimize) {
                        this.optimizeIndexWriter(writer);
                    }
                }
                catch (Exception ex) {
                    e = ex;
                }
                try {
                    this.closeIndexWriter(writer);
                }
                catch (Exception ex) {
                    e = ex;
                }
                if (!withDirs) continue;
                try {
                    this.indexManager.getStore().closeDirectory(writer.dir);
                    continue;
                }
                catch (Exception ex) {
                    e = ex;
                }
            }
            if (e != null) {
                if (e instanceof SearchEngineException) {
                    throw (SearchEngineException)e;
                }
                throw new SearchEngineException("Failed to close index writers", e);
            }
        }

        public static class IndexWriterWrapper {
            public String subIndex;
            public IndexWriter indexWriter = null;
            public Directory dir;
        }
    }
}

