/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.lucene.index.HasSubIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;

public class BitSetByAliasFilter
extends Filter {
    private static final long serialVersionUID = 3618980083415921974L;
    private HashMap bitSets = new HashMap();
    private boolean hasDeletes = false;
    private HashMap deleteBySubIndex = new HashMap();

    public void clear() {
        this.bitSets.clear();
        this.deleteBySubIndex.clear();
        this.hasDeletes = false;
    }

    public boolean hasDeletes() {
        return this.hasDeletes;
    }

    public ArrayList getDeletesBySubIndex(String subIndex) {
        return (ArrayList)this.deleteBySubIndex.get(subIndex);
    }

    public Iterator subIndexDeletesIt() {
        return this.deleteBySubIndex.keySet().iterator();
    }

    public void markDeleteBySubIndex(String subIndex, int docNum, int maxDoc) {
        BitSet bitSet = (BitSet)this.bitSets.get(subIndex);
        if (bitSet == null) {
            bitSet = new BitSet(maxDoc);
            bitSet.set(0, maxDoc, true);
            this.bitSets.put(subIndex, bitSet);
        }
        bitSet.set(docNum, false);
        ArrayList<Integer> aliasDeletions = (ArrayList<Integer>)this.deleteBySubIndex.get(subIndex);
        if (aliasDeletions == null) {
            aliasDeletions = new ArrayList<Integer>();
            this.deleteBySubIndex.put(subIndex, aliasDeletions);
        }
        aliasDeletions.add(new Integer(docNum));
        this.hasDeletes = true;
    }

    public BitSet bits(IndexReader reader) throws IOException {
        if (!(reader instanceof HasSubIndexReader)) {
            return this.allBits(reader);
        }
        HasSubIndexReader hasSubIndexReader = (HasSubIndexReader)reader;
        BitSet bitSet = (BitSet)this.bitSets.get(hasSubIndexReader.getSubIndex());
        if (bitSet != null) {
            return bitSet;
        }
        return this.allBits(reader);
    }

    private BitSet allBits(IndexReader reader) {
        int maxDoc = reader.maxDoc();
        BitSet bitSet = new BitSet(maxDoc);
        bitSet.set(0, maxDoc, true);
        return bitSet;
    }
}

