/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TransIndex;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineHighlighter;
import org.compass.core.engine.SearchEngineHits;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.LuceneTermInfoVector;
import org.compass.core.lucene.engine.EmptyLuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineHighlighter;
import org.compass.core.lucene.engine.LuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.transaction.AbstractTransaction;
import org.compass.core.lucene.engine.transaction.BitSetByAliasFilter;
import org.compass.core.lucene.util.ChainedFilter;
import org.compass.core.lucene.util.LuceneUtils;
import org.compass.core.util.FieldInvoker;
import org.compass.core.util.ResourceHelper;
import org.compass.core.util.StringUtils;

public class ReadCommittedTransaction
extends AbstractTransaction {
    private static final Log log = LogFactory.getLog((Class)ReadCommittedTransaction.class);
    private static FieldInvoker indexReaderDirectoryOwner;
    private static FieldInvoker indexReaderHasChanges;
    private BitSetByAliasFilter filter;
    protected TransIndexManager transIndexManager;

    protected void doBegin() throws SearchEngineException {
        this.transIndexManager = new TransIndexManager(this.getSearchEngine().getSearchEngineFactory());
        this.filter = new BitSetByAliasFilter();
    }

    protected void doPrepare() throws SearchEngineException {
        Iterator it = this.filter.subIndexDeletesIt();
        while (it.hasNext()) {
            String subIndex = (String)it.next();
            ArrayList deletes = this.filter.getDeletesBySubIndex(subIndex);
            if (deletes == null) continue;
            try {
                IndexReader indexReader = this.transIndexManager.getTransIndexBySubIndex((String)subIndex).transIndex.getIndexReader();
                indexReaderDirectoryOwner.set(indexReader, Boolean.FALSE);
                for (int j = 0; j < deletes.size(); ++j) {
                    int docNum = (Integer)deletes.get(j);
                    indexReader.deleteDocument(docNum);
                }
            }
            catch (Exception ex) {
                throw new SearchEngineException("Failed to persist deletes for sub-index [" + subIndex + "]");
            }
        }
        this.transIndexManager.firstPhase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit(boolean onePhase) throws SearchEngineException {
        try {
            if (onePhase) {
                this.doPrepare();
            }
            this.transIndexManager.secondPhase();
            if (this.getSearchEngine().getSearchEngineFactory().getLuceneSettings().isClearCacheOnCommit()) {
                Iterator it = this.transIndexManager.transIndexMap.keySet().iterator();
                while (it.hasNext()) {
                    String subIndex = (String)it.next();
                    this.getIndexManager().clearCache(subIndex);
                }
            }
        }
        finally {
            this.transIndexManager.close();
            this.transIndexManager.clear();
            this.filter.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRollback() throws SearchEngineException {
        Iterator it = this.filter.subIndexDeletesIt();
        while (it.hasNext()) {
            String subIndex = (String)it.next();
            ArrayList deletes = this.filter.getDeletesBySubIndex(subIndex);
            if (deletes == null) continue;
            try {
                IndexReader indexReader = this.transIndexManager.getTransIndexBySubIndex((String)subIndex).transIndex.getIndexReader();
                indexReaderHasChanges.set(indexReader, Boolean.FALSE);
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to mark index reader with no changes, ignoring", (Throwable)ex);
            }
        }
        this.filter.clear();
        try {
            this.transIndexManager.rollback();
        }
        finally {
            this.transIndexManager.close();
            this.transIndexManager.clear();
        }
    }

    public void flush() throws SearchEngineException {
    }

    protected void doCreate(Resource resource) throws SearchEngineException {
        String alias = resource.getAlias();
        TransIndexWrapper wrapper = this.transIndexManager.openTransIndexByAlias(alias);
        try {
            Property[] ids = ResourceHelper.toIds(alias, resource, this.getSearchEngine().getSearchEngineFactory().getMapping());
            Analyzer analyzer = this.getAnalyzerManager().getAnalyzerByResource(resource);
            wrapper.transIndex.addResource(resource, ids, analyzer);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to create resource for alias [" + alias + "] and resource " + resource, e);
        }
    }

    protected void doDelete(Property[] ids, String alias) throws SearchEngineException {
        TransIndexWrapper wrapper = this.transIndexManager.openTransIndexByAlias(alias);
        this.markDelete(wrapper, alias, ids, this.filter);
        try {
            wrapper.transIndex.deleteTransResource(ids, alias);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to delete alias [" + alias + "] and ids [" + StringUtils.arrayToCommaDelimitedString(ids) + "]", e);
        }
    }

    public Resource[] find(Property[] ids, String alias) throws SearchEngineException {
        LuceneSearchEngineIndexManager.LuceneIndexHolder indexHolder = null;
        try {
            Searcher indexSearcher;
            TransIndexWrapper wrapper = this.transIndexManager.getTransIndexByAlias(alias);
            if (wrapper == null) {
                indexHolder = this.getIndexManager().openIndexHolderByAlias(alias);
                indexSearcher = indexHolder.getIndexSearcher();
            } else {
                indexSearcher = wrapper.transIndex.getFullIndexSearcher();
            }
            BitSetByAliasFilter qFilter = null;
            if (this.filter.hasDeletes()) {
                qFilter = this.filter;
            }
            Hits hits = this.findByIds(indexSearcher, alias, ids, qFilter);
            Resource[] resourceArray = LuceneUtils.hitsToResourceArray(hits, this.getSearchEngine());
            return resourceArray;
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to find for alias [" + alias + "] and ids [" + StringUtils.arrayToCommaDelimitedString(ids) + "]", e);
        }
        finally {
            if (indexHolder != null) {
                indexHolder.release();
            }
        }
    }

    protected SearchEngineHighlighter doHighlighter(LuceneSearchEngineQuery query) throws SearchEngineException {
        ArrayList<LuceneSearchEngineIndexManager.LuceneIndexHolder> indexHolders = new ArrayList<LuceneSearchEngineIndexManager.LuceneIndexHolder>();
        try {
            String[] subIndexes = this.getIndexManager().getStore().getSubIndexes();
            ArrayList<IndexReader> readers = new ArrayList<IndexReader>();
            for (int i = 0; i < subIndexes.length; ++i) {
                String subIndex = subIndexes[i];
                TransIndexWrapper wrapper = this.transIndexManager.getTransIndexBySubIndex(subIndex);
                if (wrapper == null) {
                    LuceneSearchEngineIndexManager.LuceneIndexHolder indexHolder = this.getIndexManager().openIndexHolderBySubIndex(subIndex);
                    indexHolders.add(indexHolder);
                    if (indexHolder.getIndexReader().numDocs() <= 0) continue;
                    readers.add(indexHolder.getIndexReader());
                    continue;
                }
                IndexReader[] transReaders = wrapper.transIndex.getFullIndexReaderAsArray();
                for (int j = 0; j < transReaders.length; ++j) {
                    readers.add(transReaders[j]);
                }
            }
            MultiReader indexReader = new MultiReader(readers.toArray(new IndexReader[readers.size()]));
            return new LuceneSearchEngineHighlighter(query, indexHolders, (IndexReader)indexReader, this.getSearchEngine());
        }
        catch (Exception e) {
            Iterator it = indexHolders.iterator();
            while (it.hasNext()) {
                LuceneSearchEngineIndexManager.LuceneIndexHolder indexHolder = (LuceneSearchEngineIndexManager.LuceneIndexHolder)it.next();
                indexHolder.release();
            }
            throw new SearchEngineException("Failed to highlight query [" + query + "]", e);
        }
    }

    protected SearchEngineHits doFind(LuceneSearchEngineQuery query) throws SearchEngineException {
        ArrayList<LuceneSearchEngineIndexManager.LuceneIndexHolder> indexHolders = new ArrayList<LuceneSearchEngineIndexManager.LuceneIndexHolder>();
        try {
            String[] subIndexes = this.getIndexManager().getStore().calcSubIndexes(query.getSubIndexes(), query.getAliases());
            ArrayList<Object> searchers = new ArrayList<Object>();
            for (int i = 0; i < subIndexes.length; ++i) {
                String subIndex = subIndexes[i];
                TransIndexWrapper wrapper = this.transIndexManager.getTransIndexBySubIndex(subIndex);
                if (wrapper == null) {
                    LuceneSearchEngineIndexManager.LuceneIndexHolder indexHolder = this.getIndexManager().openIndexHolderBySubIndex(subIndex);
                    indexHolders.add(indexHolder);
                    if (indexHolder.getIndexReader().numDocs() <= 0) continue;
                    searchers.add(indexHolder.getIndexSearcher());
                    continue;
                }
                Searcher[] transSearchers = wrapper.transIndex.getFullIndexSearcherAsArray();
                for (int j = 0; j < transSearchers.length; ++j) {
                    searchers.add(transSearchers[j]);
                }
            }
            if (searchers.size() == 0) {
                return new EmptyLuceneSearchEngineHits();
            }
            MultiSearcher indexSeracher = new MultiSearcher((Searchable[])searchers.toArray(new Searcher[searchers.size()]));
            Filter qFilter = null;
            if (this.filter.hasDeletes()) {
                qFilter = query.getFilter() == null ? this.filter : new ChainedFilter(new Filter[]{this.filter, query.getFilter().getFilter()}, ChainedFilter.ChainedFilterType.AND);
            } else if (query.getFilter() != null) {
                qFilter = query.getFilter().getFilter();
            }
            Hits hits = this.findByQuery((Searcher)indexSeracher, query, qFilter);
            return new LuceneSearchEngineHits(hits, indexHolders, this.getSearchEngine(), query);
        }
        catch (IOException e) {
            Iterator it = indexHolders.iterator();
            while (it.hasNext()) {
                LuceneSearchEngineIndexManager.LuceneIndexHolder indexHolder = (LuceneSearchEngineIndexManager.LuceneIndexHolder)it.next();
                indexHolder.release();
            }
            throw new SearchEngineException("Failed to find query [" + query + "]", e);
        }
    }

    public LuceneTermInfoVector getTermInfo(LuceneResource resource, String propertyName) throws SearchEngineException {
        if (resource.getDocNum() == -1) {
            throw new SearchEngineException("Resource is not associated with a Lucene document number, can not retrieve term info");
        }
        String alias = resource.getAlias();
        LuceneSearchEngineIndexManager.LuceneIndexHolder indexHolder = null;
        try {
            IndexReader indexReader;
            TransIndexWrapper wrapper = this.transIndexManager.getTransIndexByAlias(alias);
            if (wrapper == null) {
                indexHolder = this.getIndexManager().openIndexHolderByAlias(alias);
                indexReader = indexHolder.getIndexReader();
            } else {
                indexReader = wrapper.transIndex.getFullIndexReader();
            }
            TermFreqVector termFreqVector = indexReader.getTermFreqVector(resource.getDocNum(), propertyName);
            if (termFreqVector == null) {
                LuceneTermInfoVector luceneTermInfoVector = null;
                return luceneTermInfoVector;
            }
            LuceneTermInfoVector luceneTermInfoVector = new LuceneTermInfoVector(termFreqVector);
            return luceneTermInfoVector;
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to fetch term info for resource [" + resource + "] and property [" + propertyName + "]", e);
        }
        finally {
            if (indexHolder != null) {
                indexHolder.release();
            }
        }
    }

    public LuceneTermInfoVector[] getTermInfos(LuceneResource resource) throws SearchEngineException {
        if (resource.getDocNum() == -1) {
            throw new SearchEngineException("Resource is not associated with a Lucene document number, can not retrieve term info");
        }
        String alias = resource.getAlias();
        LuceneSearchEngineIndexManager.LuceneIndexHolder indexHolder = null;
        try {
            IndexReader indexReader;
            TransIndexWrapper wrapper = this.transIndexManager.getTransIndexByAlias(alias);
            if (wrapper == null) {
                indexHolder = this.getIndexManager().openIndexHolderByAlias(alias);
                indexReader = indexHolder.getIndexReader();
            } else {
                indexReader = wrapper.transIndex.getFullIndexReader();
            }
            TermFreqVector[] termFreqVectors = indexReader.getTermFreqVectors(resource.getDocNum());
            if (termFreqVectors == null) {
                LuceneTermInfoVector[] luceneTermInfoVectorArray = null;
                return luceneTermInfoVectorArray;
            }
            LuceneTermInfoVector[] luceneTermInfoVectors = new LuceneTermInfoVector[termFreqVectors.length];
            for (int i = 0; i < termFreqVectors.length; ++i) {
                luceneTermInfoVectors[i] = new LuceneTermInfoVector(termFreqVectors[i]);
            }
            LuceneTermInfoVector[] luceneTermInfoVectorArray = luceneTermInfoVectors;
            return luceneTermInfoVectorArray;
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to fetch term info for resource [" + resource + "]", e);
        }
        finally {
            if (indexHolder != null) {
                indexHolder.release();
            }
        }
    }

    private Hits findByIds(Searcher indexSearcher, String alias, Property[] ids, Filter filter) throws SearchEngineException {
        BooleanQuery query;
        int numberOfAliases = this.getIndexManager().getStore().getNumberOfAliasesByAlias(alias);
        if (numberOfAliases == 1 && ids.length == 1) {
            query = new TermQuery(new Term(ids[0].getName(), ids[0].getStringValue()));
        } else {
            Term t;
            BooleanQuery bQuery = new BooleanQuery();
            if (numberOfAliases > 1) {
                String aliasProperty = this.getSearchEngine().getSearchEngineFactory().getLuceneSettings().getAliasProperty();
                t = new Term(aliasProperty, alias);
                bQuery.add((Query)new TermQuery(t), BooleanClause.Occur.MUST);
            }
            for (int i = 0; i < ids.length; ++i) {
                t = new Term(ids[i].getName(), ids[i].getStringValue());
                bQuery.add((Query)new TermQuery(t), BooleanClause.Occur.MUST);
            }
            query = bQuery;
        }
        try {
            if (filter == null) {
                return indexSearcher.search((Query)query);
            }
            return indexSearcher.search((Query)query, filter);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to search for alias [" + alias + "] and properties [" + StringUtils.arrayToCommaDelimitedString(ids) + "]", e);
        }
    }

    private Hits findByQuery(Searcher indexSearcher, LuceneSearchEngineQuery searchEngineQuery, Filter filter) throws SearchEngineException {
        Hits hits;
        Query query = searchEngineQuery.getQuery();
        Sort sort = searchEngineQuery.getSort();
        try {
            hits = filter == null ? indexSearcher.search(query, sort) : indexSearcher.search(query, filter, sort);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to search with query [" + query + "].");
        }
        return hits;
    }

    private void markDelete(TransIndexWrapper wrapper, String alias, Property[] ids, BitSetByAliasFilter filter) throws SearchEngineException {
        block18: {
            try {
                boolean moreThanOneAliasPerSubIndex;
                String subIndex = this.getIndexManager().getStore().getSubIndexForAlias(alias);
                boolean bl = moreThanOneAliasPerSubIndex = this.getIndexManager().getStore().getNumberOfAliasesByAlias(alias) > 1;
                if (ids.length == 1 && !moreThanOneAliasPerSubIndex) {
                    Property id = ids[0];
                    Term t = new Term(id.getName(), id.getStringValue());
                    TermDocs termDocs = null;
                    try {
                        termDocs = wrapper.transIndex.getIndexReader().termDocs(t);
                        if (termDocs == null) break block18;
                        int maxDoc = wrapper.transIndex.getIndexReader().maxDoc();
                        try {
                            while (termDocs.next()) {
                                filter.markDeleteBySubIndex(subIndex, termDocs.doc(), maxDoc);
                            }
                            break block18;
                        }
                        catch (IOException e) {
                            throw new SearchEngineException("Failed to iterate data in order to delete", e);
                        }
                    }
                    catch (IOException e) {
                        throw new SearchEngineException("Failed to search for property [" + id + "]", e);
                    }
                    finally {
                        try {
                            if (termDocs != null) {
                                termDocs.close();
                            }
                        }
                        catch (IOException e) {}
                    }
                }
                Hits hits = this.findByIds(wrapper.transIndex.getIndexSearcher(), alias, ids, null);
                if (hits.length() != 0) {
                    int maxDoc = wrapper.transIndex.getIndexSearcher().maxDoc();
                    for (int i = 0; i < hits.length(); ++i) {
                        int docNum = hits.id(i);
                        filter.markDeleteBySubIndex(subIndex, docNum, maxDoc);
                    }
                }
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to delete", e);
            }
        }
    }

    static {
        try {
            indexReaderDirectoryOwner = new FieldInvoker(IndexReader.class, "directoryOwner").prepare();
            indexReaderHasChanges = new FieldInvoker(IndexReader.class, "hasChanges").prepare();
        }
        catch (Exception e) {
            log.error((Object)"Failed to read index reader properties", (Throwable)e);
        }
    }

    public class TransIndexManager {
        private HashMap transIndexMap = new HashMap();
        private ArrayList transIndexList = new ArrayList();
        private LuceneSearchEngineIndexManager indexManager;
        private LuceneSettings luceneSettings;

        public TransIndexManager(LuceneSearchEngineFactory searchEngineFactory) {
            this.indexManager = searchEngineFactory.getLuceneIndexManager();
            this.luceneSettings = searchEngineFactory.getLuceneSettings();
        }

        public TransIndexWrapper getTransIndexByAlias(String alias) {
            String subIndex = this.indexManager.getStore().getSubIndexForAlias(alias);
            return this.getTransIndexBySubIndex(subIndex);
        }

        public TransIndexWrapper getTransIndexBySubIndex(String subIndex) {
            return (TransIndexWrapper)this.transIndexMap.get(subIndex);
        }

        public TransIndexWrapper openTransIndexByAlias(String alias) throws SearchEngineException {
            String subIndex = this.indexManager.getStore().getSubIndexForAlias(alias);
            return this.openTransIndexBySubIndex(subIndex);
        }

        public TransIndexWrapper openTransIndexBySubIndex(String subIndex) throws SearchEngineException {
            TransIndexWrapper wrapper = (TransIndexWrapper)this.transIndexMap.get(subIndex);
            if (wrapper == null) {
                wrapper = new TransIndexWrapper();
                wrapper.subIndex = subIndex;
                try {
                    wrapper.dir = this.indexManager.getStore().getDirectoryBySubIndex(subIndex, false);
                    wrapper.transIndex = new TransIndex(subIndex, wrapper.dir, this.luceneSettings);
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to open index for sub-index [" + subIndex + "]", e);
                }
                this.transIndexMap.put(subIndex, wrapper);
                this.transIndexList.add(wrapper);
            }
            return wrapper;
        }

        public void firstPhase() throws SearchEngineException {
            for (int i = 0; i < this.transIndexList.size(); ++i) {
                TransIndexWrapper wrapper = (TransIndexWrapper)this.transIndexList.get(i);
                try {
                    wrapper.transIndex.firstPhase();
                    continue;
                }
                catch (IOException ex) {
                    throw new SearchEngineException("Failed in first phase commit from sub-index [" + wrapper.subIndex + "]", ex);
                }
            }
        }

        public void secondPhase() throws SearchEngineException {
            for (int i = 0; i < this.transIndexList.size(); ++i) {
                TransIndexWrapper wrapper = (TransIndexWrapper)this.transIndexList.get(i);
                try {
                    wrapper.transIndex.secondPhase();
                    continue;
                }
                catch (IOException ex) {
                    throw new SearchEngineException("Failed in second phase commit from sub-index [" + wrapper.subIndex + "]", ex);
                }
            }
        }

        public void rollback() throws SearchEngineException {
            IOException e = null;
            Iterator it = this.transIndexList.iterator();
            while (it.hasNext()) {
                TransIndexWrapper wrapper = (TransIndexWrapper)it.next();
                try {
                    wrapper.transIndex.rollback();
                }
                catch (IOException ex) {
                    e = ex;
                }
            }
            if (e != null) {
                throw new SearchEngineException("Failed to rollback", e);
            }
        }

        public void close() throws SearchEngineException {
            Exception e = null;
            for (int i = 0; i < this.transIndexList.size(); ++i) {
                TransIndexWrapper wrapper = (TransIndexWrapper)this.transIndexList.get(i);
                try {
                    wrapper.transIndex.close();
                }
                catch (IOException ex) {
                    e = ex;
                }
                try {
                    this.indexManager.getStore().closeDirectory(wrapper.dir);
                    continue;
                }
                catch (Exception ex) {
                    e = ex;
                }
            }
            if (e != null) {
                if (e instanceof SearchEngineException) {
                    throw (SearchEngineException)e;
                }
                throw new SearchEngineException("Failed to close index writers", e);
            }
        }

        public void clear() {
            this.transIndexList.clear();
            this.transIndexMap.clear();
        }
    }

    public static class TransIndexWrapper {
        public String subIndex;
        public TransIndex transIndex;
        public Directory dir;
    }
}

