/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.compass.core.mapping.AbstractMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MultipleMapping;
import org.compass.core.mapping.OverrideByNameMapping;

public abstract class AbstractMultipleMapping
extends AbstractMapping
implements MultipleMapping {
    protected ArrayList mappings = new ArrayList();
    protected HashMap mappingsByNameMap = new HashMap();

    public void removeExistingByName(Mapping mapping) {
        if (this.mappingsByNameMap.get(mapping.getName()) != null) {
            for (int i = 0; i < this.mappings.size(); ++i) {
                Mapping tempMapping = (Mapping)this.mappings.get(i);
                if (tempMapping.getName() == null || !tempMapping.getName().equals(mapping.getName())) continue;
                this.mappings.remove(i);
                break;
            }
            this.mappingsByNameMap.remove(mapping.getName());
        }
    }

    public int addMapping(Mapping mapping) {
        if (mapping instanceof OverrideByNameMapping && ((OverrideByNameMapping)mapping).isOverrideByName()) {
            this.removeExistingByName(mapping);
        }
        this.mappingsByNameMap.put(mapping.getName(), mapping);
        this.mappings.add(mapping);
        return this.mappings.size() - 1;
    }

    public Iterator mappingsIt() {
        return this.mappings.iterator();
    }

    public int mappingsSize() {
        return this.mappings.size();
    }

    public Mapping getMapping(String name) {
        return (Mapping)this.mappingsByNameMap.get(name);
    }

    public Mapping getMapping(int index) {
        return (Mapping)this.mappings.get(index);
    }

    public void clearMappings() {
        this.mappings.clear();
        this.mappingsByNameMap.clear();
    }

    protected void copy(MultipleMapping mapping) {
        super.copy(mapping);
        Iterator it = this.mappingsIt();
        while (it.hasNext()) {
            mapping.addMapping(((Mapping)it.next()).copy());
        }
    }

    protected void shallowCopy(MultipleMapping mapping) {
        super.copy(mapping);
    }
}

