/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.compass.core.Property;
import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.mapping.AbstractMultipleMapping;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.PostProcessingMapping;
import org.compass.core.mapping.ResourceAnalyzerController;
import org.compass.core.mapping.ResourceIdMappingProvider;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;

public abstract class AbstractResourceMapping
extends AbstractMultipleMapping
implements ResourceMapping,
AliasMapping,
PostProcessingMapping {
    private String alias;
    private String subIndex;
    private String[] extendedMappings;
    private String analyzer;
    private float boost;
    private boolean isRoot = true;
    private boolean isAllSupported;
    private String allProperty;
    private Property.TermVector allTermVector = Property.TermVector.NO;
    private String allAnalyzer;
    private ResourcePropertyMapping[] ids = new ResourcePropertyMapping[0];
    private Map resourcePropertyMappingsByNameMap;
    private Map resourcePropertyMappingsByPathMap;
    private String[] resourcePropertyNames;
    private boolean hasSpecificAnalyzerPerResourceProperty;
    private ResourceAnalyzerController analyzerController;

    public ResourcePropertyMapping[] getIdMappings() {
        return this.ids;
    }

    protected void copy(AbstractResourceMapping resourceMapping) {
        super.copy(resourceMapping);
        this.shallowCopy(resourceMapping);
    }

    public void shallowCopy(AbstractResourceMapping resourceMapping) {
        super.shallowCopy(resourceMapping);
        resourceMapping.setAlias(this.getAlias());
        resourceMapping.setSubIndex(this.getSubIndex());
        resourceMapping.setExtendedMappings(this.getExtendedMappings());
        resourceMapping.setAllProperty(this.getAllProperty());
        resourceMapping.setAllSupported(this.isAllSupported());
        resourceMapping.setRoot(this.isRoot());
        resourceMapping.setBoost(this.getBoost());
        resourceMapping.setAllTermVector(this.getAllTermVector());
        resourceMapping.setAnalyzer(this.getAnalyzer());
        resourceMapping.setAllAnalyzer(this.getAllAnalyzer());
    }

    public void postProcess() throws MappingException {
        this.doPostProcess();
        this.buildResourcePropertyMap();
        this.buildAnalyzerSpecificFlag();
        this.buildResourceIds();
    }

    protected abstract void doPostProcess() throws MappingException;

    private void buildResourceIds() {
        ArrayList<ResourcePropertyMapping> resourceIds = new ArrayList<ResourcePropertyMapping>();
        Iterator it = this.mappingsIt();
        while (it.hasNext()) {
            Mapping mapping = (Mapping)it.next();
            if (!(mapping instanceof ResourceIdMappingProvider)) continue;
            ResourcePropertyMapping[] tempIds = ((ResourceIdMappingProvider)((Object)mapping)).getIdMappings();
            for (int i = 0; i < tempIds.length; ++i) {
                resourceIds.add(tempIds[i]);
            }
        }
        this.ids = resourceIds.toArray(new ResourcePropertyMapping[resourceIds.size()]);
    }

    private void buildResourcePropertyMap() {
        int i;
        this.resourcePropertyMappingsByPathMap = new HashMap();
        HashMap<String, ArrayList<ResourcePropertyMapping>> tempMap = new HashMap<String, ArrayList<ResourcePropertyMapping>>();
        ResourcePropertyMapping[] resourcePropertyMappings = this.getResourcePropertyMappings();
        for (i = 0; i < resourcePropertyMappings.length; ++i) {
            ResourcePropertyMapping resourcePropertyMapping = resourcePropertyMappings[i];
            this.resourcePropertyMappingsByPathMap.put(resourcePropertyMapping.getPath(), resourcePropertyMapping);
            ArrayList<ResourcePropertyMapping> propertyList = (ArrayList<ResourcePropertyMapping>)tempMap.get(resourcePropertyMapping.getName());
            if (propertyList == null) {
                propertyList = new ArrayList<ResourcePropertyMapping>();
                tempMap.put(resourcePropertyMapping.getName(), propertyList);
            }
            propertyList.add(resourcePropertyMapping);
        }
        this.resourcePropertyNames = new String[tempMap.size()];
        i = 0;
        this.resourcePropertyMappingsByNameMap = new HashMap();
        Iterator it = tempMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String propertyName = (String)entry.getKey();
            this.resourcePropertyNames[i++] = propertyName;
            ArrayList propertyList = (ArrayList)entry.getValue();
            this.resourcePropertyMappingsByNameMap.put(propertyName, propertyList.toArray(new ResourcePropertyMapping[propertyList.size()]));
        }
    }

    private void buildAnalyzerSpecificFlag() {
        Iterator it = this.resourcePropertyMappingsByNameMap.keySet().iterator();
        while (it.hasNext()) {
            String propertyName = (String)it.next();
            ResourcePropertyMapping[] mappings = (ResourcePropertyMapping[])this.resourcePropertyMappingsByNameMap.get(propertyName);
            if (mappings[0].getAnalyzer() == null) continue;
            this.hasSpecificAnalyzerPerResourceProperty = true;
        }
    }

    public int addMapping(Mapping mapping) {
        if (mapping instanceof ResourceAnalyzerController) {
            this.analyzerController = (ResourceAnalyzerController)((Object)mapping);
        }
        return super.addMapping(mapping);
    }

    public ResourcePropertyMapping[] getResourcePropertyMappings(String propertyName) {
        return (ResourcePropertyMapping[])this.resourcePropertyMappingsByNameMap.get(propertyName);
    }

    public ResourcePropertyMapping getResourcePropertyMapping(String propertyName) {
        ResourcePropertyMapping[] retVal = this.getResourcePropertyMappings(propertyName);
        if (retVal == null) {
            return null;
        }
        return retVal[0];
    }

    public ResourcePropertyMapping getResourcePropertyMappingByPath(PropertyPath path) {
        return (ResourcePropertyMapping)this.resourcePropertyMappingsByPathMap.get(path);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String[] getExtendedMappings() {
        return this.extendedMappings;
    }

    public void setExtendedMappings(String[] extendedMappings) {
        this.extendedMappings = extendedMappings;
    }

    public float getBoost() {
        return this.boost;
    }

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public String getAllProperty() {
        return this.allProperty;
    }

    public void setAllProperty(String allProperty) {
        this.allProperty = allProperty;
    }

    public boolean isAllSupported() {
        return this.isAllSupported;
    }

    public void setAllSupported(boolean isAllSupported) {
        this.isAllSupported = isAllSupported;
    }

    public String getSubIndex() {
        return this.subIndex;
    }

    public void setSubIndex(String subIndex) {
        this.subIndex = subIndex;
        if (this.subIndex != null) {
            this.subIndex = this.subIndex.toLowerCase();
        }
    }

    public Property.TermVector getAllTermVector() {
        return this.allTermVector;
    }

    public void setAllTermVector(Property.TermVector allTermVector) {
        this.allTermVector = allTermVector;
    }

    public boolean hasSpecificAnalyzerPerResourceProperty() {
        return this.hasSpecificAnalyzerPerResourceProperty;
    }

    public String getAllAnalyzer() {
        return this.allAnalyzer;
    }

    public void setAllAnalyzer(String allAnalyzer) {
        this.allAnalyzer = allAnalyzer;
    }

    public ResourceAnalyzerController getAnalyzerController() {
        return this.analyzerController;
    }

    public void setAnalyzerController(ResourceAnalyzerController analyzerController) {
        this.analyzerController = analyzerController;
    }

    public String[] getResourcePropertyNames() {
        return this.resourcePropertyNames;
    }
}

