/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.converter.ResourcePropertyConverter;
import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.NullResourceMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.rsem.RawResourceMapping;

public class CompassMapping {
    private final HashMap mappings = new HashMap();
    private final HashMap rootMappingsByAlias = new HashMap();
    private final HashMap rootMappingsByClass = new HashMap();
    private final HashMap mappingsByClass = new HashMap();
    private ResourceMapping[] rootMappingsArr = new ResourceMapping[0];
    private ConverterLookup converterLookup;
    private final HashMap cachedRootMappignsByClass = new HashMap();
    private final NullResourceMapping nullResourceMappingEntryInCache = new NullResourceMapping();
    private HashSet hasMutipleClassMappingByClass = new HashSet();
    private PropertyPath path;

    public CompassMapping copy(ConverterLookup converterLookup) {
        CompassMapping copy = new CompassMapping();
        copy.converterLookup = converterLookup;
        copy.setPath(this.getPath());
        Iterator it = this.mappings.values().iterator();
        while (it.hasNext()) {
            AliasMapping copyMapping = (AliasMapping)((AliasMapping)it.next()).copy();
            copy.addMapping(copyMapping);
        }
        return copy;
    }

    public void clearMappings() {
        this.mappings.clear();
        this.rootMappingsByAlias.clear();
        this.rootMappingsByClass.clear();
        this.rootMappingsArr = new ResourceMapping[0];
        this.cachedRootMappignsByClass.clear();
        this.hasMutipleClassMappingByClass.clear();
        this.mappingsByClass.clear();
    }

    public ResourcePropertyLookup getResourcePropertyLookup(String name) {
        return new ResourcePropertyLookup(name);
    }

    public void addMapping(AliasMapping mapping) throws MappingException {
        if (this.mappings.get(mapping.getAlias()) != null) {
            throw new MappingException("Compass does not allow multiple aliases for alias [" + mapping.getAlias() + "]");
        }
        this.mappings.put(mapping.getAlias(), mapping);
        if (mapping instanceof ResourceMapping) {
            ResourceMapping resourceMapping = (ResourceMapping)((Object)mapping);
            if (resourceMapping.isRoot()) {
                this.rootMappingsByAlias.put(mapping.getAlias(), mapping);
                if (resourceMapping instanceof ClassMapping) {
                    ClassMapping cMapping = (ClassMapping)mapping;
                    if (this.rootMappingsByClass.get(cMapping.getName()) != null) {
                        this.hasMutipleClassMappingByClass.add(cMapping.getName());
                    }
                    this.rootMappingsByClass.put(cMapping.getName(), mapping);
                    this.mappingsByClass.put(cMapping.getName(), cMapping);
                }
                ResourceMapping[] result = new ResourceMapping[this.rootMappingsArr.length + 1];
                for (int i = 0; i < this.rootMappingsArr.length; ++i) {
                    result[i] = this.rootMappingsArr[i];
                }
                result[i] = resourceMapping;
                this.rootMappingsArr = result;
            } else if (resourceMapping instanceof ClassMapping) {
                ClassMapping cMapping = (ClassMapping)mapping;
                this.mappingsByClass.put(cMapping.getName(), cMapping);
            }
        }
    }

    public ResourcePropertyMapping getResourcePropertyMappingByPath(String path) {
        int dotIndex = path.indexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        String alias = path.substring(0, dotIndex);
        ResourceMapping resourceMapping = this.getRootMappingByAlias(alias);
        if (resourceMapping == null) {
            throw new IllegalArgumentException("Failed to find class/resource mapping for alias [" + alias + "] from path [" + path + "]");
        }
        ResourcePropertyMapping resourcePropertyMapping = resourceMapping.getResourcePropertyMappingByDotPath(path.substring(dotIndex + 1));
        if (resourcePropertyMapping == null) {
            throw new IllegalArgumentException("Failed to find mapping for alias [" + alias + "] and path [" + path + "]");
        }
        return resourcePropertyMapping;
    }

    public Iterator mappingsIt() {
        return this.mappings.values().iterator();
    }

    public AliasMapping getAliasMapping(String alias) {
        return (AliasMapping)this.mappings.get(alias);
    }

    public ResourceMapping getResourceMappingByAlias(String alias) {
        return (ResourceMapping)this.mappings.get(alias);
    }

    public ResourceMapping getRootMappingByAlias(String alias) {
        return (ResourceMapping)this.rootMappingsByAlias.get(alias);
    }

    public boolean hasRootMappingByAlias(String alias) {
        return this.rootMappingsByAlias.get(alias) != null;
    }

    public boolean hasClassMapping(String alias) {
        return this.rootMappingsByAlias.get(alias) instanceof ClassMapping;
    }

    public boolean hasRawResourceMapping(String alias) {
        return this.rootMappingsByAlias.get(alias) instanceof RawResourceMapping;
    }

    public boolean hasMultipleClassMapping(String className) {
        return this.hasMutipleClassMappingByClass.contains(className);
    }

    public ClassMapping getClassMappingByClass(String className) {
        return (ClassMapping)this.mappingsByClass.get(className);
    }

    public ResourceMapping findRootMappingByClass(Class clazz) throws MappingException {
        return this.doGetResourceMappingByClass(clazz, true);
    }

    public ResourceMapping getRootMappingByClass(Class clazz) throws MappingException {
        return this.doGetResourceMappingByClass(clazz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceMapping doGetResourceMappingByClass(Class clazz, boolean throwEx) throws MappingException {
        ResourceMapping rm = (ResourceMapping)this.cachedRootMappignsByClass.get(clazz);
        if (rm != null) {
            if (rm == this.nullResourceMappingEntryInCache) {
                if (throwEx) {
                    throw new MappingException("Failed to find any mappings for class [" + clazz.getName() + "]");
                }
                return null;
            }
            return rm;
        }
        HashMap hashMap = this.cachedRootMappignsByClass;
        synchronized (hashMap) {
            rm = this.doGetActualResourceMappingByClass(clazz);
            this.cachedRootMappignsByClass.put(clazz, rm);
            if (rm == null) {
                this.cachedRootMappignsByClass.put(clazz, this.nullResourceMappingEntryInCache);
                if (throwEx) {
                    throw new MappingException("Failed to find any mappings for class [" + clazz.getName() + "]");
                }
                return null;
            }
            return rm;
        }
    }

    private ResourceMapping doGetActualResourceMappingByClass(Class clazz) {
        ResourceMapping rm = (ResourceMapping)this.rootMappingsByClass.get(clazz.getName());
        if (rm != null) {
            return rm;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            rm = (ResourceMapping)this.rootMappingsByClass.get(interfaces[i].getName());
            if (rm == null) continue;
            return rm;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass == null) {
            return null;
        }
        return this.doGetActualResourceMappingByClass(superClass);
    }

    public ResourceMapping[] getRootMappings() {
        return this.rootMappingsArr;
    }

    public ConverterLookup getConverterLookup() {
        return this.converterLookup;
    }

    public PropertyPath getPath() {
        return this.path;
    }

    public void setPath(PropertyPath path) {
        this.path = path;
    }

    public final class ResourcePropertyLookup {
        private ResourcePropertyMapping resourcePropertyMapping;
        private String path;

        public ResourcePropertyLookup(String name) {
            if (name.charAt(0) == '\'' && name.charAt(name.length() - 1) == '\'') {
                this.path = name.substring(1, name.length() - 1);
            } else {
                this.resourcePropertyMapping = CompassMapping.this.getResourcePropertyMappingByPath(name);
                this.path = this.resourcePropertyMapping == null ? name : this.resourcePropertyMapping.getPath().getPath();
            }
        }

        public String getPath() {
            return this.path;
        }

        public String getValue(Object value) {
            ResourcePropertyConverter converter = this.resourcePropertyMapping != null && this.resourcePropertyMapping.getConverter() != null ? (ResourcePropertyConverter)this.resourcePropertyMapping.getConverter() : (ResourcePropertyConverter)CompassMapping.this.getConverterLookup().lookupConverter(value.getClass());
            return converter.toString(value, this.resourcePropertyMapping);
        }
    }
}

