/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.osem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.mapping.AbstractResourceMapping;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.PostProcessingMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassIdPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.OsemMappingUtils;

public class ClassMapping
extends AbstractResourceMapping
implements ResourceMapping,
PostProcessingMapping {
    private PropertyPath classPath;
    private Class clazz;
    private boolean poly;
    private Class polyClass;
    private ResourcePropertyMapping[] resourcePropertyMappings;
    private ClassPropertyMapping[] classPropertyMappings;
    private ClassIdPropertyMapping[] classPropertyIdMappings;
    private HashMap pathMappings;

    public Mapping copy() {
        ClassMapping copy = new ClassMapping();
        super.copy(copy);
        copy.setPoly(this.isPoly());
        copy.setClassPath(this.getClassPath());
        copy.setClazz(this.getClazz());
        copy.setPolyClass(this.getPolyClass());
        return copy;
    }

    public AliasMapping shallowCopy() {
        ClassMapping copy = new ClassMapping();
        super.shallowCopy(copy);
        copy.setPoly(this.isPoly());
        copy.setClassPath(this.getClassPath());
        copy.setClazz(this.getClazz());
        copy.setPolyClass(this.getPolyClass());
        return copy;
    }

    protected void doPostProcess() throws MappingException {
        OsemMappingUtils.ClassPropertyAndResourcePropertyGathererAndPathBuilder callback = new OsemMappingUtils.ClassPropertyAndResourcePropertyGathererAndPathBuilder();
        OsemMappingUtils.iterateMappings(callback, this.mappingsIt());
        List findList = callback.getResourcePropertyMappings();
        this.resourcePropertyMappings = findList.toArray(new ResourcePropertyMapping[findList.size()]);
        findList = callback.getClassPropertyMappings();
        this.classPropertyMappings = findList.toArray(new ClassPropertyMapping[findList.size()]);
        findList = this.findClassPropertyIdMappings();
        this.classPropertyIdMappings = findList.toArray(new ClassIdPropertyMapping[findList.size()]);
        this.pathMappings = callback.getPathMappings();
    }

    public ResourcePropertyMapping[] getResourcePropertyMappings() {
        return this.resourcePropertyMappings;
    }

    public ClassPropertyMapping[] getClassPropertyMappings() {
        return this.classPropertyMappings;
    }

    public ClassIdPropertyMapping[] getClassPropertyIdMappings() {
        return this.classPropertyIdMappings;
    }

    public List findClassPropertyIdMappings() {
        ArrayList<Mapping> idMappingList = new ArrayList<Mapping>();
        Iterator it = this.mappingsIt();
        while (it.hasNext()) {
            Mapping m = (Mapping)it.next();
            if (!(m instanceof ClassIdPropertyMapping)) continue;
            idMappingList.add(m);
        }
        return idMappingList;
    }

    public ResourcePropertyMapping getResourcePropertyMappingByDotPath(String path) {
        return (ResourcePropertyMapping)this.pathMappings.get(path);
    }

    public boolean isIncludePropertiesWithNoMappingsInAll() {
        return true;
    }

    public boolean isPoly() {
        return this.poly;
    }

    public void setPoly(boolean poly) {
        this.poly = poly;
    }

    public PropertyPath getClassPath() {
        return this.classPath;
    }

    public void setClassPath(PropertyPath classPath) {
        this.classPath = classPath;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public Class getPolyClass() {
        return this.polyClass;
    }

    public void setPolyClass(Class polyClass) {
        this.polyClass = polyClass;
    }
}

