/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.osem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.ComponentMapping;
import org.compass.core.mapping.osem.ConstantMetaDataMapping;
import org.compass.core.mapping.osem.ReferenceMapping;

public abstract class OsemMappingUtils {
    public static void iterateMappings(ClassMappingCallback callback, Iterator mappingsIt) {
        while (mappingsIt.hasNext()) {
            Mapping m = (Mapping)mappingsIt.next();
            if (m instanceof ClassPropertyMapping) {
                ClassPropertyMapping classPropertyMapping = (ClassPropertyMapping)m;
                callback.onBeginMultipleMapping(classPropertyMapping);
                callback.onClassPropertyMapping(classPropertyMapping);
                Iterator resIt = classPropertyMapping.mappingsIt();
                while (resIt.hasNext()) {
                    ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)resIt.next();
                    callback.onResourcePropertyMapping(resourcePropertyMapping);
                }
                callback.onEndMultiplMapping(classPropertyMapping);
                continue;
            }
            if (m instanceof ComponentMapping) {
                ComponentMapping componentMapping = (ComponentMapping)m;
                callback.onBeginMultipleMapping(componentMapping);
                callback.onComponentMapping(componentMapping);
                OsemMappingUtils.iterateMappings(callback, componentMapping.getRefClassMapping().mappingsIt());
                callback.onEndMultiplMapping(componentMapping);
                continue;
            }
            if (m instanceof ReferenceMapping) {
                ReferenceMapping referenceMapping = (ReferenceMapping)m;
                callback.onBeginMultipleMapping(referenceMapping);
                callback.onReferenceMapping(referenceMapping);
                OsemMappingUtils.iterateMappings(callback, referenceMapping.getRefClassMapping().mappingsIt());
                if (referenceMapping.getRefCompMapping() != null) {
                    OsemMappingUtils.iterateMappings(callback, referenceMapping.getRefCompMapping().mappingsIt());
                }
                callback.onEndMultiplMapping(referenceMapping);
                continue;
            }
            if (m instanceof ConstantMetaDataMapping) {
                ConstantMetaDataMapping constantMetaDataMapping = (ConstantMetaDataMapping)m;
                callback.onBeginMultipleMapping(constantMetaDataMapping);
                callback.onResourcePropertyMapping(constantMetaDataMapping);
                callback.onEndMultiplMapping(constantMetaDataMapping);
                continue;
            }
            if (!(m instanceof AbstractCollectionMapping)) continue;
            AbstractCollectionMapping colMapping = (AbstractCollectionMapping)m;
            callback.onBeginCollectionMapping(colMapping);
            Mapping elementMapping = colMapping.getElementMapping();
            if (elementMapping instanceof ClassPropertyMapping) {
                ClassPropertyMapping classPropertyMapping = (ClassPropertyMapping)elementMapping;
                callback.onBeginMultipleMapping(classPropertyMapping);
                callback.onClassPropertyMapping(classPropertyMapping);
                Iterator resIt = classPropertyMapping.mappingsIt();
                while (resIt.hasNext()) {
                    ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)resIt.next();
                    callback.onResourcePropertyMapping(resourcePropertyMapping);
                }
                callback.onEndMultiplMapping(classPropertyMapping);
            } else if (elementMapping instanceof ComponentMapping) {
                ComponentMapping componentMapping = (ComponentMapping)elementMapping;
                callback.onBeginMultipleMapping(componentMapping);
                callback.onComponentMapping(componentMapping);
                OsemMappingUtils.iterateMappings(callback, componentMapping.getRefClassMapping().mappingsIt());
                callback.onEndMultiplMapping(componentMapping);
            } else if (elementMapping instanceof ReferenceMapping) {
                ReferenceMapping referenceMapping = (ReferenceMapping)elementMapping;
                callback.onBeginMultipleMapping(referenceMapping);
                callback.onReferenceMapping(referenceMapping);
                callback.onReferenceMapping(referenceMapping);
                OsemMappingUtils.iterateMappings(callback, referenceMapping.getRefClassMapping().mappingsIt());
                if (referenceMapping.getRefCompMapping() != null) {
                    OsemMappingUtils.iterateMappings(callback, referenceMapping.getRefCompMapping().mappingsIt());
                }
                callback.onEndMultiplMapping(referenceMapping);
            }
            callback.onEndCollectionMapping(colMapping);
        }
    }

    public static class ClassPropertyAndResourcePropertyGathererAndPathBuilder
    extends ClassPropertyAndResourcePropertyGatherer {
        private HashMap pathMappings = new HashMap();
        private String currentPath = "";

        private void addToPath(Mapping mapping) {
            if (this.currentPath.length() != 0) {
                this.currentPath = this.currentPath + ".";
            }
            this.currentPath = this.currentPath + mapping.getName();
        }

        private void removeFromPath(Mapping mapping) {
            int endIndex = this.currentPath.length() - mapping.getName().length();
            this.currentPath = endIndex <= 0 ? "" : this.currentPath.substring(0, endIndex - 1);
        }

        public void onBeginMultipleMapping(Mapping mapping) {
            super.onBeginMultipleMapping(mapping);
            this.addToPath(mapping);
        }

        public void onEndMultiplMapping(Mapping mapping) {
            super.onEndMultiplMapping(mapping);
            this.removeFromPath(mapping);
        }

        public void onClassPropertyMapping(ClassPropertyMapping mapping) {
            super.onClassPropertyMapping(mapping);
            ClassPropertyMetaDataMapping resourcePropertyMapping = mapping.getIdMapping();
            this.pathMappings.put(this.currentPath, resourcePropertyMapping);
        }

        public void onResourcePropertyMapping(ResourcePropertyMapping mapping) {
            super.onResourcePropertyMapping(mapping);
            if (!mapping.isInternal()) {
                this.addToPath(mapping);
            }
            this.pathMappings.put(this.currentPath, mapping);
            if (!mapping.isInternal()) {
                this.removeFromPath(mapping);
            }
        }

        public HashMap getPathMappings() {
            return this.pathMappings;
        }
    }

    public static class ClassPropertyAndResourcePropertyGatherer
    implements ClassMappingCallback {
        private ArrayList classPropertyMappings = new ArrayList();
        private ArrayList resourcePropertyMappings = new ArrayList();

        public void addResourcePropertyMapping(ResourcePropertyMapping resourcePropertyMapping) {
            this.resourcePropertyMappings.add(resourcePropertyMapping);
        }

        public ArrayList getClassPropertyMappings() {
            return this.classPropertyMappings;
        }

        public ArrayList getResourcePropertyMappings() {
            return this.resourcePropertyMappings;
        }

        public void onBeginMultipleMapping(Mapping mapping) {
        }

        public void onEndMultiplMapping(Mapping mapping) {
        }

        public void onBeginCollectionMapping(AbstractCollectionMapping collectionMapping) {
        }

        public void onEndCollectionMapping(AbstractCollectionMapping collectionMapping) {
        }

        public void onClassPropertyMapping(ClassPropertyMapping classPropertyMapping) {
            this.classPropertyMappings.add(classPropertyMapping);
        }

        public void onComponentMapping(ComponentMapping componentMapping) {
        }

        public void onReferenceMapping(ReferenceMapping referenceMapping) {
        }

        public void onConstantMetaDataMappaing(ConstantMetaDataMapping constantMetaDataMapping) {
        }

        public void onResourcePropertyMapping(ResourcePropertyMapping resourcePropertyMapping) {
            this.resourcePropertyMappings.add(resourcePropertyMapping);
        }
    }

    public static interface ClassMappingCallback {
        public void onBeginMultipleMapping(Mapping var1);

        public void onEndMultiplMapping(Mapping var1);

        public void onBeginCollectionMapping(AbstractCollectionMapping var1);

        public void onEndCollectionMapping(AbstractCollectionMapping var1);

        public void onClassPropertyMapping(ClassPropertyMapping var1);

        public void onComponentMapping(ComponentMapping var1);

        public void onReferenceMapping(ReferenceMapping var1);

        public void onConstantMetaDataMappaing(ConstantMetaDataMapping var1);

        public void onResourcePropertyMapping(ResourcePropertyMapping var1);
    }
}

