/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.xsem;

import java.util.Iterator;
import org.compass.core.mapping.AbstractResourceMapping;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.InvalidMappingException;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.OverrideByNameMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.xsem.XPathEnabledMapping;
import org.compass.core.mapping.xsem.XmlContentMapping;
import org.compass.core.xml.XmlXPathExpression;

public class XmlObjectMapping
extends AbstractResourceMapping
implements XPathEnabledMapping {
    private ResourcePropertyMapping[] resourcePropertyMappings;
    private String xpath;
    private XmlXPathExpression xpathExpression;
    private XmlContentMapping xmlContentMapping;

    public Mapping copy() {
        XmlObjectMapping copy = new XmlObjectMapping();
        copy.setXPath(this.getXPath());
        this.copy(copy);
        return copy;
    }

    public AliasMapping shallowCopy() {
        XmlObjectMapping copy = new XmlObjectMapping();
        copy.setXPath(this.getXPath());
        this.shallowCopy(copy);
        return copy;
    }

    public boolean isIncludePropertiesWithNoMappingsInAll() {
        return true;
    }

    public int addMapping(Mapping mapping) {
        ResourcePropertyMapping resourcePropertyMapping;
        if (!(!(mapping instanceof ResourcePropertyMapping) || this.mappingsByNameMap.get((resourcePropertyMapping = (ResourcePropertyMapping)mapping).getName()) == null || resourcePropertyMapping instanceof OverrideByNameMapping && ((OverrideByNameMapping)((Object)resourcePropertyMapping)).isOverrideByName())) {
            throw new InvalidMappingException("Two resource property mappings are mapped to property path [" + resourcePropertyMapping.getPath().getPath() + "], it is not allowed");
        }
        if (mapping instanceof XmlContentMapping) {
            this.xmlContentMapping = (XmlContentMapping)mapping;
        }
        return super.addMapping(mapping);
    }

    protected void doPostProcess() throws MappingException {
        this.resourcePropertyMappings = new ResourcePropertyMapping[this.mappingsSize()];
        int i = 0;
        Iterator it = this.mappingsIt();
        while (it.hasNext()) {
            this.resourcePropertyMappings[i++] = (ResourcePropertyMapping)it.next();
        }
    }

    public ResourcePropertyMapping getResourcePropertyMappingByDotPath(String path) {
        return (ResourcePropertyMapping)this.mappingsByNameMap.get(path);
    }

    public ResourcePropertyMapping[] getResourcePropertyMappings() {
        return this.resourcePropertyMappings;
    }

    public String getXPath() {
        return this.xpath;
    }

    public void setXPath(String xpath) {
        this.xpath = xpath;
    }

    public XmlXPathExpression getXPathExpression() {
        return this.xpathExpression;
    }

    public void setXPathExpression(XmlXPathExpression xpathExpression) {
        this.xpathExpression = xpathExpression;
    }

    public XmlContentMapping getXmlContentMapping() {
        return this.xmlContentMapping;
    }
}

