/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.marshall;

import org.compass.core.CompassException;
import org.compass.core.Resource;
import org.compass.core.accessor.Setter;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.converter.mapping.ResourceMappingConverter;
import org.compass.core.engine.SearchEngine;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.marshall.DefaultMarshallingContext;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.marshall.MarshallingException;
import org.compass.core.marshall.MarshallingStrategy;
import org.compass.core.spi.AliasedObject;
import org.compass.core.spi.InternalCompassSession;

public class DefaultMarshallingStrategy
implements MarshallingStrategy {
    private CompassMapping mapping;
    private SearchEngine searchEngine;
    private ConverterLookup converterLookup;
    private InternalCompassSession session;

    public DefaultMarshallingStrategy(CompassMapping mapping, SearchEngine searchEngine, ConverterLookup converterLookup, InternalCompassSession session) {
        this.mapping = mapping;
        this.searchEngine = searchEngine;
        this.converterLookup = converterLookup;
        this.session = session;
    }

    public Resource marshallIds(Object id) {
        if (id instanceof AliasedObject) {
            return this.marshallIds(((AliasedObject)id).getAlias(), id);
        }
        return this.marshallIds(id.getClass(), id);
    }

    public Resource marshallIds(String alias, Object id) {
        ResourceMapping resourceMapping = this.mapping.getRootMappingByAlias(alias);
        if (resourceMapping == null) {
            throw new MarshallingException("Failed to find mapping for alias [" + alias + "]");
        }
        return this.marshallIds(resourceMapping, id);
    }

    public Resource marshallIds(Class clazz, Object id) {
        ResourceMapping resourceMapping = this.mapping.findRootMappingByClass(clazz);
        if (resourceMapping == null) {
            throw new MarshallingException("Failed to find mapping for class [" + clazz.getName() + "]");
        }
        return this.marshallIds(resourceMapping, id);
    }

    public Resource marshallIds(ResourceMapping resourceMapping, Object id) {
        Resource idResource = this.searchEngine.createResource(resourceMapping.getAlias());
        this.marshallIds(idResource, resourceMapping, id, this.createContext());
        return idResource;
    }

    public boolean marshallIds(Resource resource, ResourceMapping resourceMapping, Object id, MarshallingContext context) {
        return ((ResourceMappingConverter)resourceMapping.getConverter()).marshallIds(resource, id, resourceMapping, context);
    }

    public void marshallIds(Object root, Object id) {
        ClassMapping classMapping = (ClassMapping)this.mapping.getRootMappingByClass(root.getClass());
        ResourcePropertyMapping[] ids = classMapping.getIdMappings();
        Object[] idsValues = this.unmarshallIds(classMapping, id, this.createContext());
        for (int i = 0; i < idsValues.length; ++i) {
            this.setId(root, idsValues[i], (ClassPropertyMetaDataMapping)ids[i]);
        }
    }

    private void setId(Object root, Object id, ClassPropertyMetaDataMapping mdMapping) {
        Setter setter = mdMapping.getSetter();
        setter.set(root, id);
    }

    public Object[] unmarshallIds(String alias, Object id) {
        ResourceMapping resourceMapping = this.mapping.getRootMappingByAlias(alias);
        return this.unmarshallIds(resourceMapping, id, this.createContext());
    }

    public Object[] unmarshallIds(Class clazz, Object id) {
        ResourceMapping resourceMapping = this.mapping.findRootMappingByClass(clazz);
        return this.unmarshallIds(resourceMapping, id, this.createContext());
    }

    public Object[] unmarshallIds(ResourceMapping resourceMapping, Object id, MarshallingContext context) {
        return ((ResourceMappingConverter)resourceMapping.getConverter()).unmarshallIds(id, resourceMapping, context);
    }

    public Resource marshall(String alias, Object root) {
        ResourceMapping resourceMapping = this.mapping.getRootMappingByAlias(alias);
        if (resourceMapping == null) {
            throw new MarshallingException("No mapping is defined for alias [" + alias + "]");
        }
        Resource resource = this.searchEngine.createResource(alias);
        resourceMapping.getConverter().marshall(resource, root, resourceMapping, this.createContext());
        return resource;
    }

    public Resource marshall(Object root) {
        if (root instanceof AliasedObject) {
            return this.marshall(((AliasedObject)root).getAlias(), root);
        }
        ResourceMapping resourceMapping = this.mapping.findRootMappingByClass(root.getClass());
        if (resourceMapping == null) {
            throw new MarshallingException("No mapping is defined for class [" + root.getClass().getName() + "]");
        }
        Resource resource = this.searchEngine.createResource(resourceMapping.getAlias());
        resourceMapping.getConverter().marshall(resource, root, resourceMapping, this.createContext());
        return resource;
    }

    public Object unmarshall(Resource resource) throws CompassException {
        return this.unmarshall(resource, this.createContext());
    }

    public Object unmarshall(Resource resource, MarshallingContext context) throws CompassException {
        ResourceMapping resourceMapping = this.mapping.getRootMappingByAlias(resource.getAlias());
        if (resourceMapping == null) {
            throw new MarshallingException("No mapping is defined for alias [ " + resource.getAlias() + "]");
        }
        return resourceMapping.getConverter().unmarshall(resource, resourceMapping, context);
    }

    private MarshallingContext createContext() {
        return new DefaultMarshallingContext(this.mapping, this.searchEngine, this.converterLookup, this.session, this);
    }
}

