/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.CompassTransaction;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.AbstractTransaction;
import org.compass.core.transaction.JTASyncTransactionFactory;
import org.compass.core.transaction.TransactionException;

public class JTASyncTransaction
extends AbstractTransaction {
    private static final Log log = LogFactory.getLog((Class)JTASyncTransaction.class);
    private UserTransaction ut;
    private boolean newTransaction;
    private boolean controllingNewTransaction = false;
    private boolean commitFailed;

    public JTASyncTransaction(UserTransaction ut) {
        this.ut = ut;
    }

    public void begin(InternalCompassSession session, TransactionManager transactionManager, CompassTransaction.TransactionIsolation transactionIsolation, boolean commitBeforeCompletion) throws CompassException {
        try {
            this.controllingNewTransaction = true;
            boolean bl = this.newTransaction = this.ut.getStatus() == 6;
            if (this.newTransaction) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Beginning new JTA transaction, and a new compass transaction on thread [" + Thread.currentThread().getName() + "]"));
                }
                session.getSearchEngine().begin(transactionIsolation);
                this.ut.begin();
            } else {
                session.getSearchEngine().begin(transactionIsolation);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Joining an existing JTA transaction, starting a new compass transaction on thread [" + Thread.currentThread().getName() + "]"));
                }
            }
            Transaction tx = transactionManager.getTransaction();
            tx.registerSynchronization((Synchronization)new JTATransactionSynchronization(session, tx, this.newTransaction, commitBeforeCompletion));
        }
        catch (Exception e) {
            throw new TransactionException("Begin failed with exception", e);
        }
        this.setBegun(true);
    }

    public void join() throws CompassException {
        this.controllingNewTransaction = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Joining an existing compass transcation on thread [" + Thread.currentThread().getName() + "]"));
        }
    }

    protected void doCommit() throws CompassException {
        if (!this.controllingNewTransaction) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not committing JTA transaction since compass does not control it on thread [" + Thread.currentThread().getName() + "]"));
            }
            return;
        }
        if (this.newTransaction) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Committing JTA transaction controlled by compass on thread [" + Thread.currentThread().getName() + "]"));
            }
            try {
                this.ut.commit();
            }
            catch (Exception e) {
                this.commitFailed = true;
                throw new TransactionException("Commit failed", e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Commit called, let JTA synchronization commit the transaciton on thread [" + Thread.currentThread().getName() + "]"));
        }
    }

    protected void doRollback() throws CompassException {
        try {
            if (this.newTransaction) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Rolling back JTA transaction controlled by compass on thread [" + Thread.currentThread().getName() + "]"));
                }
                if (!this.commitFailed) {
                    this.ut.rollback();
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Marking JTA transaction as rolled back since compass controlls it on thread [" + Thread.currentThread().getName() + "]"));
                }
                this.ut.setRollbackOnly();
            }
        }
        catch (Exception e) {
            throw new TransactionException("Rollback failed with exception", e);
        }
    }

    public boolean wasRolledBack() throws TransactionException {
        int status;
        if (!this.isBegun()) {
            return false;
        }
        if (this.commitFailed) {
            return true;
        }
        try {
            status = this.ut.getStatus();
        }
        catch (SystemException se) {
            throw new TransactionException("Could not determine transaction status", se);
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 1 || status == 9 || status == 4;
    }

    public boolean wasCommitted() throws TransactionException {
        int status;
        if (!this.isBegun() || this.commitFailed) {
            return false;
        }
        try {
            status = this.ut.getStatus();
        }
        catch (SystemException se) {
            throw new TransactionException("Could not determine transaction status: ", se);
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 3;
    }

    private static class JTATransactionSynchronization
    implements Synchronization {
        private InternalCompassSession session;
        private Transaction tx;
        private boolean compassControlledJtaTransaction;
        private boolean commitBeforeCompletion;

        public JTATransactionSynchronization(InternalCompassSession session, Transaction tx, boolean compassControlledJtaTransaction, boolean commitBeforeCompletion) {
            this.session = session;
            this.tx = tx;
            this.compassControlledJtaTransaction = compassControlledJtaTransaction;
            this.commitBeforeCompletion = commitBeforeCompletion;
        }

        public void beforeCompletion() {
            if (!this.commitBeforeCompletion) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Committing compass transaction using JTA synchronization beforeCompletion on thread [" + Thread.currentThread().getName() + "]"));
            }
            this.session.getSearchEngine().commit(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                if (!this.commitBeforeCompletion) {
                    if (status == 3) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Committing compass transaction using JTA synchronization afterCompletion on thread [" + Thread.currentThread().getName() + "]"));
                        }
                        this.session.getSearchEngine().commit(true);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Rolling back compass transaction using JTA synchronization afterCompletion on thread [" + Thread.currentThread().getName() + "]"));
                        }
                        this.session.getSearchEngine().rollback();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception occured when sync with transaction", (Throwable)e);
            }
            finally {
                this.session.evictAll();
                ((JTASyncTransactionFactory)this.session.getCompass().getTransactionFactory()).unbindSessionFromTransaction(this.tx);
                if (!this.compassControlledJtaTransaction) {
                    this.session.close();
                }
            }
        }
    }
}

