/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.config.CompassSettings;
import org.compass.core.jndi.NamingHelper;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.AbstractTransactionFactory;
import org.compass.core.transaction.InternalCompassTransaction;
import org.compass.core.transaction.JTASyncTransaction;
import org.compass.core.transaction.TransactionException;
import org.compass.core.transaction.TransactionManagerLookup;
import org.compass.core.transaction.TransactionManagerLookupFactory;

public class JTASyncTransactionFactory
extends AbstractTransactionFactory {
    private static final Log log = LogFactory.getLog((Class)JTASyncTransactionFactory.class);
    private static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    private transient Map currentSessionMap = new Hashtable();
    private InitialContext context;
    private String utName;
    private UserTransaction userTransaction;
    private TransactionManager transactionManager;

    public void doConfigure(CompassSettings settings) throws CompassException {
        boolean cacheUserTransaction;
        try {
            this.context = NamingHelper.getInitialContext(settings);
        }
        catch (NamingException ne) {
            throw new CompassException("Could not obtain initial context", ne);
        }
        this.utName = settings.getSetting("compass.transaction.userTransactionName");
        TransactionManagerLookup lookup = TransactionManagerLookupFactory.getTransactionManagerLookup(settings);
        if (lookup != null) {
            this.transactionManager = lookup.getTransactionManager(settings);
            if (this.transactionManager == null) {
                throw new CompassException("Failed to find transaction manager");
            }
            if (this.utName == null) {
                this.utName = lookup.getUserTransactionName();
            }
        } else {
            throw new CompassException("Must register a transaction manager lookup using the compass.transaction.managerLookup property");
        }
        if (this.utName == null) {
            this.utName = DEFAULT_USER_TRANSACTION_NAME;
        }
        if (cacheUserTransaction = settings.getSettingAsBoolean("compass.transaction.cacheUserTransaction", true)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caching JTA UserTransaction from Jndi [" + this.utName + "]"));
            }
            this.userTransaction = this.lookupUserTransaction();
        }
    }

    public InternalCompassTransaction doBeginTransaction(InternalCompassSession session, CompassTransaction.TransactionIsolation transactionIsolation) throws CompassException {
        JTASyncTransaction tx = new JTASyncTransaction(this.getUserTransaction());
        tx.begin(session, this.transactionManager, transactionIsolation, this.commitBeforeCompletion);
        return tx;
    }

    protected InternalCompassTransaction doContinueTransaction(InternalCompassSession session) throws CompassException {
        JTASyncTransaction tx = new JTASyncTransaction(this.getUserTransaction());
        tx.join();
        return tx;
    }

    public CompassSession getTransactionBoundSession() throws CompassException {
        UserTransaction ut = this.getUserTransaction();
        try {
            if (ut.getStatus() == 6) {
                return null;
            }
            Transaction tr = this.transactionManager.getTransaction();
            return (CompassSession)this.currentSessionMap.get(tr);
        }
        catch (SystemException e) {
            throw new TransactionException("Failed to fetch transaction bound session", e);
        }
    }

    protected void doBindSessionToTransaction(CompassTransaction tr, CompassSession session) throws CompassException {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            this.currentSessionMap.put(tx, session);
        }
        catch (SystemException e) {
            throw new TransactionException("Failed to bind session to transcation", e);
        }
    }

    public void unbindSessionFromTransaction(Transaction tx) {
        this.currentSessionMap.remove(tx);
    }

    private UserTransaction getUserTransaction() throws TransactionException {
        if (this.userTransaction != null) {
            return this.userTransaction;
        }
        return this.lookupUserTransaction();
    }

    private UserTransaction lookupUserTransaction() throws TransactionException {
        UserTransaction ut;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking for UserTransaction under [" + this.utName + "]"));
        }
        try {
            ut = (UserTransaction)this.context.lookup(this.utName);
        }
        catch (NamingException ne) {
            throw new TransactionException("Could not find UserTransaction in JNDI under [" + this.utName + "]", ne);
        }
        if (ut == null) {
            throw new TransactionException("A naming service lookup returned null under [" + this.utName + "]");
        }
        return ut;
    }
}

