/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction;

import java.util.HashMap;
import java.util.Map;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.AbstractTransactionFactory;
import org.compass.core.transaction.InternalCompassTransaction;
import org.compass.core.transaction.LocalTransaction;

public class LocalTransactionFactory
extends AbstractTransactionFactory {
    private static final ThreadLocal context = new ThreadLocal();

    protected InternalCompassTransaction doBeginTransaction(InternalCompassSession session, CompassTransaction.TransactionIsolation transactionIsolation) throws CompassException {
        LocalTransaction tx = new LocalTransaction(session, transactionIsolation);
        tx.begin();
        return tx;
    }

    protected InternalCompassTransaction doContinueTransaction(InternalCompassSession session) throws CompassException {
        LocalTransaction tx = new LocalTransaction(session, null);
        tx.join();
        return tx;
    }

    public CompassSession getTransactionBoundSession() throws CompassException {
        Map sessionMap = LocalTransactionFactory.sessionMap();
        if (sessionMap == null) {
            return null;
        }
        return (CompassSession)sessionMap.get(this.compass);
    }

    public void unbindSessionFromTransaction(LocalTransaction tr, CompassSession session) {
        Map sessionMap = LocalTransactionFactory.sessionMap();
        if (sessionMap != null) {
            sessionMap.remove(this.compass);
            if (sessionMap.isEmpty()) {
                context.set(null);
            }
        }
    }

    protected void doBindSessionToTransaction(CompassTransaction tr, CompassSession session) throws CompassException {
        HashMap<Compass, CompassSession> sessionMap = LocalTransactionFactory.sessionMap();
        if (sessionMap == null) {
            sessionMap = new HashMap<Compass, CompassSession>();
            context.set(sessionMap);
        }
        sessionMap.put(this.compass, session);
    }

    private static Map sessionMap() {
        return (Map)context.get();
    }
}

