/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.transaction.LocalTransactionFactory;
import org.compass.core.transaction.TransactionFactory;
import org.compass.core.util.ClassUtils;

public class TransactionFactoryFactory {
    private static final Log log = LogFactory.getLog((Class)TransactionFactoryFactory.class);

    public static TransactionFactory createTransactionFactory(Compass compass, CompassSettings settings) {
        String factoryClassName = settings.getSetting("compass.transaction.factory", LocalTransactionFactory.class.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using transaction factory [" + factoryClassName + "]"));
        }
        try {
            TransactionFactory factory = (TransactionFactory)ClassUtils.forName(factoryClassName).newInstance();
            factory.configure(compass, settings);
            return factory;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create transaction factory class [" + factoryClassName + "]", e);
        }
    }
}

