/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util;

import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.util.StringUtils;

public abstract class ResourceHelper {
    private ResourceHelper() {
    }

    public static Property[] toIds(String alias, Resource resource, CompassMapping mapping) throws SearchEngineException {
        ResourceMapping resourceMapping = mapping.getRootMappingByAlias(alias);
        if (resourceMapping == null) {
            throw new SearchEngineException("Failed to find mappings for alias [" + alias + "]");
        }
        ResourcePropertyMapping[] pMappings = resourceMapping.getIdMappings();
        Property[] ids = new Property[pMappings.length];
        for (int i = 0; i < pMappings.length; ++i) {
            ids[i] = resource.getProperty(pMappings[i].getPath().getPath());
            if (ids[i] == null) {
                throw new SearchEngineException("Id with path [" + pMappings[i].getPath() + "] for alias [" + alias + "] not found");
            }
            if (ids[i].isIndexed() && !ids[i].isTokenized() && ids[i].isStored()) continue;
            throw new SearchEngineException("Id [" + ids[i].getName() + "] for alias [" + alias + "] must be stored and un_tokenized");
        }
        return ids;
    }

    public static Property[] toIds(SearchEngine searchEngine, String[] values, ResourceMapping mapping) throws SearchEngineException {
        Object[] idsMapping = mapping.getIdMappings();
        if (values.length != idsMapping.length) {
            throw new SearchEngineException("The id values don't match the id mapping. Id values [" + StringUtils.arrayToCommaDelimitedString(values) + "], Ids Mappings [" + StringUtils.arrayToCommaDelimitedString(idsMapping) + "]");
        }
        Property[] properties = new Property[values.length];
        for (int i = 0; i < values.length; ++i) {
            String name = idsMapping[i].getPath().getPath();
            properties[i] = searchEngine.createProperty(name, values[i], Property.Store.YES, Property.Index.UN_TOKENIZED);
        }
        return properties;
    }
}

