/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.backport.java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import org.compass.core.util.backport.java.util.concurrent.TimeUnit;
import org.compass.core.util.backport.java.util.concurrent.helpers.FIFOWaitQueue;
import org.compass.core.util.backport.java.util.concurrent.helpers.Utils;
import org.compass.core.util.backport.java.util.concurrent.helpers.WaitQueue;

public class Semaphore
implements Serializable {
    private static final long serialVersionUID = -3222578661600680210L;
    private final Sync sync;

    public Semaphore(int permits) {
        this.sync = new NonfairSync(permits);
    }

    public Semaphore(int permits, boolean fair) {
        this.sync = fair ? new FairSync(permits) : new NonfairSync(permits);
    }

    public void acquire() throws InterruptedException {
        this.sync.acquire();
    }

    public void acquireUninterruptibly() {
        this.sync.acquireUninterruptibly();
    }

    public boolean tryAcquire() {
        return this.sync.attempt();
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.attempt(unit.toNanos(timeout));
    }

    public void release() {
        this.sync.release(1);
    }

    public void release(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.release(permits);
    }

    public int availablePermits() {
        return this.sync.getPermits();
    }

    public int drainPermits() {
        return this.sync.drain();
    }

    protected void reducePermits(int reduction) {
        if (reduction < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.reduce(reduction);
    }

    public boolean isFair() {
        return this.sync instanceof FairSync;
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public String toString() {
        return super.toString() + "[Permits = " + this.sync.getPermits() + "]";
    }

    static final class FairSync
    extends Sync
    implements WaitQueue.QueuedSync {
        private static final long serialVersionUID = 2014338818796000944L;
        private transient WaitQueue wq_ = new FIFOWaitQueue();

        FairSync(int initialPermits) {
            super(initialPermits);
        }

        public void acquireUninterruptibly() {
            if (this.precheck()) {
                return;
            }
            WaitQueue.WaitNode w = new WaitQueue.WaitNode();
            w.doWaitUninterruptibly(this);
        }

        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.precheck()) {
                return;
            }
            WaitQueue.WaitNode w = new WaitQueue.WaitNode();
            w.doWait(this);
        }

        public boolean attempt(long nanos) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.precheck()) {
                return true;
            }
            if (nanos <= 0L) {
                return false;
            }
            WaitQueue.WaitNode w = new WaitQueue.WaitNode();
            return w.doTimedWait(this, nanos);
        }

        protected synchronized boolean precheck() {
            boolean pass;
            boolean bl = pass = this.permits_ > 0;
            if (pass) {
                --this.permits_;
            }
            return pass;
        }

        public synchronized boolean recheck(WaitQueue.WaitNode w) {
            boolean pass;
            boolean bl = pass = this.permits_ > 0;
            if (pass) {
                --this.permits_;
            } else {
                this.wq_.insert(w);
            }
            return pass;
        }

        public void takeOver(WaitQueue.WaitNode n) {
        }

        protected synchronized WaitQueue.WaitNode getSignallee() {
            WaitQueue.WaitNode w = this.wq_.extract();
            if (w == null) {
                ++this.permits_;
            }
            return w;
        }

        public void release() {
            WaitQueue.WaitNode w;
            do {
                if ((w = this.getSignallee()) != null) continue;
                return;
            } while (!w.signal(this));
        }

        public void release(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            for (int i = 0; i < n; ++i) {
                this.release();
            }
        }

        public synchronized boolean hasQueuedThreads() {
            return this.wq_.hasNodes();
        }

        public synchronized int getQueueLength() {
            return this.wq_.getLength();
        }

        public synchronized Collection getQueuedThreads() {
            return this.wq_.getWaitingThreads();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            FairSync fairSync = this;
            synchronized (fairSync) {
                this.wq_ = new FIFOWaitQueue();
            }
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -2694183684443567898L;

        protected NonfairSync(int initialPermits) {
            super(initialPermits);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquireUninterruptibly() {
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.permits_ > 0) {
                    --this.permits_;
                    return;
                }
                boolean wasInterrupted = Thread.interrupted();
                try {
                    do {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            wasInterrupted = true;
                        }
                    } while (this.permits_ <= 0);
                    --this.permits_;
                    return;
                }
                finally {
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                while (this.permits_ <= 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        this.notify();
                        throw ex;
                    }
                }
                --this.permits_;
            }
        }

        public boolean attempt(long nanos) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.permits_ > 0) {
                    --this.permits_;
                    return true;
                }
                if (nanos <= 0L) {
                    return false;
                }
                try {
                    long deadline = Utils.nanoTime() + nanos;
                    do {
                        TimeUnit.NANOSECONDS.timedWait(this, nanos);
                        if (this.permits_ <= 0) continue;
                        --this.permits_;
                        return true;
                    } while ((nanos = deadline - Utils.nanoTime()) > 0L);
                    return false;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }

        public synchronized void release(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            this.permits_ += n;
            for (int i = 0; i < n; ++i) {
                this.notify();
            }
        }

        public boolean hasQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public int getQueueLength() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public Collection getQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }
    }

    static abstract class Sync
    implements Serializable {
        private static final long serialVersionUID = 1192457210091910933L;
        int permits_;

        protected Sync(int permits) {
            this.permits_ = permits;
        }

        abstract void acquireUninterruptibly();

        abstract void acquire() throws InterruptedException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean attempt() {
            Sync sync = this;
            synchronized (sync) {
                if (this.permits_ > 0) {
                    --this.permits_;
                    return true;
                }
                return false;
            }
        }

        abstract boolean attempt(long var1) throws InterruptedException;

        abstract void release(int var1);

        public synchronized int getPermits() {
            return this.permits_;
        }

        public synchronized int drain() {
            int acquired = this.permits_;
            this.permits_ = 0;
            return acquired;
        }

        public synchronized void reduce(int reduction) {
            this.permits_ -= reduction;
        }

        abstract boolean hasQueuedThreads();

        abstract int getQueueLength();

        abstract Collection getQueuedThreads();
    }
}

