/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.reader;

import java.io.Reader;
import org.compass.core.engine.RepeatableReader;

public class StringReader
extends Reader
implements RepeatableReader {
    private String str;
    private int length;
    private int next = 0;
    private int mark = 0;

    public StringReader(String s) {
        this.str = s;
        this.length = s.length();
    }

    public int read() {
        if (this.next >= this.length) {
            return -1;
        }
        return this.str.charAt(this.next++);
    }

    public int read(char[] cbuf, int off, int len) {
        if (len == 0) {
            return 0;
        }
        if (this.next >= this.length) {
            return -1;
        }
        int n = Math.min(this.length - this.next, len);
        this.str.getChars(this.next, this.next + n, cbuf, off);
        this.next += n;
        return n;
    }

    public long skip(long ns) {
        if (this.next >= this.length) {
            return 0L;
        }
        long n = Math.min((long)(this.length - this.next), ns);
        this.next = (int)((long)this.next + n);
        return n;
    }

    public boolean ready() {
        return true;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.mark = this.next;
    }

    public void reset() {
        this.next = this.mark;
    }

    public void close() {
        this.next = 0;
        this.mark = 0;
    }
}

