/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.ibatis;

import com.ibatis.common.util.PaginatedList;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapSession;
import java.sql.SQLException;
import java.util.Iterator;
import org.compass.core.CompassSession;
import org.compass.gps.CompassGpsException;
import org.compass.gps.device.AbstractGpsDevice;
import org.compass.gps.device.ibatis.SqlMapGpsDeviceException;

public class SqlMapClientGpsDevice
extends AbstractGpsDevice {
    private SqlMapClient sqlMapClient;
    private String[] selectStatementsIds;
    private Object[] statementsParameterObjects;
    private int pageSize = 200;

    public SqlMapClientGpsDevice() {
    }

    public SqlMapClientGpsDevice(String deviceName, SqlMapClient sqlMapClient, String[] selectStatementsIds) {
        this(deviceName, sqlMapClient, selectStatementsIds, null);
    }

    public SqlMapClientGpsDevice(String deviceName, SqlMapClient sqlMapClient, String[] selectStatementsIds, Object[] statementsParameterObjects) {
        this.setName(deviceName);
        this.sqlMapClient = sqlMapClient;
        this.selectStatementsIds = selectStatementsIds;
        this.statementsParameterObjects = statementsParameterObjects;
    }

    protected void doStart() throws CompassGpsException {
        if (this.sqlMapClient == null) {
            throw new IllegalArgumentException(this.buildMessage("Must set sqlMapClaient property"));
        }
        if (this.selectStatementsIds == null) {
            throw new IllegalArgumentException(this.buildMessage("Must set selectStatementsIds property"));
        }
        if (this.selectStatementsIds.length == 0) {
            throw new IllegalArgumentException(this.buildMessage("selectStatementsIds property must have at least one entry"));
        }
        if (this.statementsParameterObjects != null && this.statementsParameterObjects.length != this.selectStatementsIds.length) {
            throw new IllegalArgumentException(this.buildMessage("Once the statementsParameterObjects property is set, it must have the same length as the selectStatementsIds property"));
        }
    }

    public SqlMapClient getSqlMapClient() {
        return this.sqlMapClient;
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doIndex(CompassSession session) throws CompassGpsException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)this.buildMessage("Indexing the database with page size [" + this.pageSize + "]"));
        }
        for (int i = 0; i < this.selectStatementsIds.length; ++i) {
            SqlMapSession sqlMapSession = this.sqlMapClient.openSession();
            try {
                sqlMapSession.startTransaction();
                Object parameterObject = null;
                if (this.statementsParameterObjects != null) {
                    parameterObject = this.statementsParameterObjects[i];
                }
                PaginatedList paginatedList = sqlMapSession.queryForPaginatedList(this.selectStatementsIds[i], parameterObject, this.pageSize);
                do {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)this.buildMessage("Indexing select statement id [" + this.selectStatementsIds[i] + "] page [" + paginatedList.getPageIndex() + "]"));
                    }
                    Iterator it = paginatedList.iterator();
                    while (it.hasNext()) {
                        session.create(it.next());
                    }
                    session.evictAll();
                } while (paginatedList.nextPage());
                sqlMapSession.commitTransaction();
                continue;
            }
            catch (SQLException e) {
                throw new SqlMapGpsDeviceException("Failed to fetch paginated list for statement [" + this.selectStatementsIds[i] + "]", e);
            }
            finally {
                try {
                    try {
                        sqlMapSession.endTransaction();
                    }
                    catch (Exception e) {
                        this.log.warn((Object)this.buildMessage("Failed to close sqlMap session, ignoring"), (Throwable)e);
                    }
                }
                finally {
                    sqlMapSession.close();
                }
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)this.buildMessage("Finished indexing the database"));
        }
    }

    public String[] getSelectStatementsIds() {
        return this.selectStatementsIds;
    }

    public void setSelectStatementsIds(String[] statementsNames) {
        this.selectStatementsIds = statementsNames;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Object[] getStatementsParameterObjects() {
        return this.statementsParameterObjects;
    }

    public void setStatementsParameterObjects(Object[] statementsParameterObjects) {
        this.statementsParameterObjects = statementsParameterObjects;
    }
}

