/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import org.compass.core.Compass;
import org.compass.core.CompassSession;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.spi.InternalCompass;
import org.compass.core.spi.InternalCompassSession;
import org.compass.gps.device.jdbc.JdbcGpsDeviceException;
import org.compass.gps.device.jdbc.dialect.JdbcDialect;
import org.compass.gps.device.jdbc.mapping.ColumnToPropertyMapping;
import org.compass.gps.device.jdbc.mapping.ResultSetToResourceMapping;
import org.compass.gps.device.jdbc.mapping.VersionColumnMapping;
import org.compass.gps.device.jdbc.snapshot.JdbcAliasRowSnapshot;

public class ResultSetRowMarshallHelper {
    private ResultSetToResourceMapping mapping;
    private CompassSession session;
    private JdbcDialect dialect;
    private JdbcAliasRowSnapshot rowSnapshot;
    private Resource resource;
    private boolean marshallResource = false;
    private boolean marshallVersioning = false;
    private ResourceMapping resourceMapping;

    public ResultSetRowMarshallHelper(ResultSetToResourceMapping mapping, CompassSession session, JdbcDialect dialect, Resource resource) {
        this(mapping, session, dialect, resource, null);
    }

    public ResultSetRowMarshallHelper(ResultSetToResourceMapping mapping, JdbcDialect dialect, JdbcAliasRowSnapshot rowSnapshot, Compass compass) {
        this(mapping, null, dialect, null, rowSnapshot, compass);
    }

    public ResultSetRowMarshallHelper(ResultSetToResourceMapping mapping, CompassSession session, JdbcDialect dialect, Resource resource, JdbcAliasRowSnapshot rowSnapshot) {
        this(mapping, session, dialect, resource, rowSnapshot, ((InternalCompassSession)session).getCompass());
    }

    public ResultSetRowMarshallHelper(ResultSetToResourceMapping mapping, CompassSession session, JdbcDialect dialect, Resource resource, JdbcAliasRowSnapshot rowSnapshot, Compass compass) {
        this.mapping = mapping;
        this.session = session;
        this.dialect = dialect;
        this.rowSnapshot = rowSnapshot;
        this.resourceMapping = ((InternalCompass)compass).getMapping().getResourceMappingByAlias(mapping.getAlias());
        this.marshallVersioning = rowSnapshot != null && mapping.supportsVersioning();
        this.resource = resource;
        this.marshallResource = resource != null;
    }

    public void marshallResultSet(ResultSet rs) throws SQLException {
        this.marshallIds(rs);
        this.marshallVersionsIfNeeded(rs);
        this.marshallMappedData(rs);
        this.marshallUnMappedIfNeeded(rs);
    }

    public void marshallIds(ResultSet rs) throws SQLException {
        Iterator it = this.mapping.idMappingsIt();
        while (it.hasNext()) {
            ColumnToPropertyMapping ctpMapping = (ColumnToPropertyMapping)it.next();
            String value = this.dialect.getStringValue(rs, ctpMapping);
            if (value == null) {
                throw new JdbcGpsDeviceException("Id [" + ctpMapping + "] for alias [" + this.mapping.getAlias() + "] can not be null");
            }
            if (this.marshallResource) {
                this.marshallProperty(ctpMapping, value);
            }
            if (!this.marshallVersioning) continue;
            this.rowSnapshot.addIdValue(value);
        }
    }

    public void marshallMappedData(ResultSet rs) throws SQLException {
        if (!this.marshallResource) {
            return;
        }
        Iterator it = this.mapping.dataMappingsIt();
        while (it.hasNext()) {
            ColumnToPropertyMapping ctpMapping = (ColumnToPropertyMapping)it.next();
            String value = this.dialect.getStringValue(rs, ctpMapping);
            if (value == null) continue;
            this.marshallProperty(ctpMapping, value);
        }
    }

    public void marshallVersionsIfNeeded(ResultSet rs) throws SQLException {
        if (!this.marshallVersioning) {
            return;
        }
        Iterator it = this.mapping.versionMappingsIt();
        while (it.hasNext()) {
            VersionColumnMapping versionMapping = (VersionColumnMapping)it.next();
            Long version = this.dialect.getVersion(rs, versionMapping);
            this.rowSnapshot.addVersionValue(version);
        }
    }

    public void marshallUnMappedIfNeeded(ResultSet rs) throws SQLException {
        if (!this.marshallResource || !this.mapping.isIndexUnMappedColumns()) {
            return;
        }
        ResultSetMetaData metaData = rs.getMetaData();
        int count = metaData.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String value;
            String columnName = metaData.getColumnName(i);
            if (this.mapping.getMappingsForColumn(columnName) != null || this.mapping.getMappingsForColumn(i) != null || (value = this.dialect.getStringValue(rs, i)) == null) continue;
            Property p = this.session.createProperty(columnName, value, Property.Store.YES, Property.Index.TOKENIZED);
            this.resource.addProperty(p);
        }
    }

    public void marshallProperty(ColumnToPropertyMapping ctpMapping, String value) {
        ResourcePropertyMapping propertyMapping = this.resourceMapping.getResourcePropertyMapping(ctpMapping.getPropertyName());
        if (propertyMapping == null) {
            Property p = this.session.createProperty(ctpMapping.getPropertyName(), value, ctpMapping.getPropertyStore(), ctpMapping.getPropertyIndex(), ctpMapping.getPropertyTermVector());
            p.setBoost(ctpMapping.getBoost());
            this.resource.addProperty(p);
        } else {
            this.resource.addProperty(ctpMapping.getPropertyName(), value);
        }
    }
}

