/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jdbc.snapshot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.gps.device.jdbc.JdbcGpsDeviceException;
import org.compass.gps.device.jdbc.snapshot.JdbcSnapshot;
import org.compass.gps.device.jdbc.snapshot.JdbcSnapshotPersister;

public class FSJdbcSnapshotPersister
implements JdbcSnapshotPersister {
    private static final Log log = LogFactory.getLog((Class)FSJdbcSnapshotPersister.class);
    private String path;

    public FSJdbcSnapshotPersister() {
    }

    public FSJdbcSnapshotPersister(String path) {
        this.path = path;
    }

    public JdbcSnapshot load() throws JdbcGpsDeviceException {
        File file = new File(this.path);
        if (!file.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No snapshot data found at [" + this.path + "], creating a new one"));
            }
            return new JdbcSnapshot();
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Snapshot data found at [" + this.path + "], loading [" + file.length() + "bytes]"));
            }
            ObjectInputStream objStream = new ObjectInputStream(new FileInputStream(this.path));
            return (JdbcSnapshot)objStream.readObject();
        }
        catch (Exception e) {
            throw new JdbcGpsDeviceException("Failed to load jdbc snapshot", e);
        }
    }

    public void save(JdbcSnapshot snapshot) throws JdbcGpsDeviceException {
        try {
            ObjectOutputStream objStream = new ObjectOutputStream(new FileOutputStream(this.path));
            objStream.writeObject(snapshot);
            objStream.flush();
            objStream.close();
            if (log.isDebugEnabled()) {
                File file = new File(this.path);
                log.debug((Object)("Saved snapshot data to [" + this.path + "] size [" + file.length() + "bytes]"));
            }
        }
        catch (IOException e) {
            throw new JdbcGpsDeviceException("Failed to save jdbc snapshot", e);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

