/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.entities;

import javax.persistence.EntityManagerFactory;
import org.compass.core.util.ClassUtils;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.entities.DefaultJpaEntitiesLocator;
import org.compass.gps.device.jpa.entities.JpaEntitiesLocator;

public abstract class JpaEntitiesLocatorDetector {
    public static JpaEntitiesLocator detectLocator(EntityManagerFactory entityManagerFactory) {
        String locatorClassName = DefaultJpaEntitiesLocator.class.getName();
        if (entityManagerFactory.getClass().getName().equals("org.hibernate.ejb.EntityManagerFactoryImpl")) {
            locatorClassName = "org.compass.gps.device.jpa.entities.HibernateJpaEntitiesLocator";
        } else if (entityManagerFactory.getClass().getName().equals("oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerFactoryImpl")) {
            locatorClassName = "org.compass.gps.device.jpa.entities.TopLinkEssentialsJpaEntitiesLocator";
        }
        try {
            Class locatorClass = ClassUtils.forName(locatorClassName);
            return (JpaEntitiesLocator)locatorClass.newInstance();
        }
        catch (Exception e) {
            throw new JpaGpsDeviceException("Failed to create locator class [" + locatorClassName + "]", e);
        }
    }
}

