/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.entities;

import java.util.ArrayList;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.InheritancePolicy;
import oracle.toplink.essentials.internal.ejb.cmp3.base.EntityManagerFactoryImpl;
import oracle.toplink.essentials.threetier.ServerSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.entities.EntityInformation;
import org.compass.gps.device.jpa.entities.JpaEntitiesLocator;
import org.compass.gps.spi.CompassGpsInterfaceDevice;

public class TopLinkEssentialsJpaEntitiesLocator
implements JpaEntitiesLocator {
    protected Log log = LogFactory.getLog(this.getClass());

    public EntityInformation[] locate(EntityManagerFactory entityManagerFactory, JpaGpsDevice device) throws JpaGpsDeviceException {
        CompassGpsInterfaceDevice gps = (CompassGpsInterfaceDevice)device.getGps();
        EntityManagerFactoryImpl emf = (EntityManagerFactoryImpl)entityManagerFactory;
        ServerSession session = emf.getServerSession();
        ArrayList<EntityInformation> entitiesList = new ArrayList<EntityInformation>();
        Map descriptors = session.getDescriptors();
        for (Object o : descriptors.values()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)o;
            String entityname = classDescriptor.getJavaClassName();
            if (!gps.hasMappingForEntityForIndex(entityname)) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Entity [" + entityname + "] does not have compass mapping, filtering it out"));
                continue;
            }
            if (this.shouldFilter(entityname, classDescriptor, device)) continue;
            Class clazz = classDescriptor.getJavaClass();
            EntityInformation entityInformation = new EntityInformation(clazz, classDescriptor.getAlias());
            entitiesList.add(entityInformation);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Entity [" + entityname + "] will be indexed"));
        }
        return entitiesList.toArray(new EntityInformation[entitiesList.size()]);
    }

    protected boolean shouldFilter(String entityname, ClassDescriptor classDescriptor, JpaGpsDevice device) {
        if (!classDescriptor.hasInheritance()) {
            return false;
        }
        InheritancePolicy inheritancePolicy = classDescriptor.getInheritancePolicy();
        if (inheritancePolicy == null || inheritancePolicy.getParentClass() == null) {
            return false;
        }
        Class superClass = inheritancePolicy.getParentClass();
        if (superClass != null && ((CompassGpsInterfaceDevice)device.getGps()).hasMappingForEntityForIndex(superClass)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Entity [" + entityname + "] is inherited and super class [" + superClass + "] has compass mapping, filtering it out"));
            }
            return true;
        }
        return false;
    }
}

