/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.lifecycle;

import javax.persistence.EntityManagerFactory;
import org.compass.core.util.ClassUtils;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.lifecycle.JpaEntityLifecycleInjector;

public abstract class JpaEntityLifecycleInjectorDetector {
    public static JpaEntityLifecycleInjector detectInjector(EntityManagerFactory entityManagerFactory) throws JpaGpsDeviceException {
        String injectorClassName = null;
        if (entityManagerFactory.getClass().getName().equals("org.hibernate.ejb.EntityManagerFactoryImpl")) {
            injectorClassName = "org.compass.gps.device.jpa.lifecycle.HibernateJpaEntityLifecycleInjector";
        } else if (entityManagerFactory.getClass().getName().equals("oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerFactoryImpl")) {
            injectorClassName = "org.compass.gps.device.jpa.lifecycle.TopLinkEssentialsJpaEntityLifecycleInjector";
        }
        if (injectorClassName == null) {
            return null;
        }
        try {
            Class injectorClass = ClassUtils.forName(injectorClassName);
            return (JpaEntityLifecycleInjector)injectorClass.newInstance();
        }
        catch (Exception e) {
            throw new JpaGpsDeviceException("Failed to create injector class [" + injectorClassName + "]", e);
        }
    }
}

