/*
 * Decompiled with CFR 0.152.
 */
package org.compass.spring.device.hibernate;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.compass.gps.device.hibernate.Hibernate3GpsDevice;
import org.compass.gps.device.hibernate.HibernateGpsDeviceException;
import org.hibernate.SessionFactory;

public class SpringHibernate3GpsDevice
extends Hibernate3GpsDevice {
    protected SessionFactory doGetActualSessionFactory() {
        SessionFactory sessionFactory = super.doGetActualSessionFactory();
        if (Proxy.isProxyClass(sessionFactory.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(sessionFactory);
            try {
                Field target = invocationHandler.getClass().getDeclaredField("target");
                target.setAccessible(true);
                sessionFactory = (SessionFactory)target.get(invocationHandler);
            }
            catch (Exception e) {
                throw new HibernateGpsDeviceException("Failed to fetch actual session factory", e);
            }
        }
        return sessionFactory;
    }
}

