/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.strutsutil;

import com.jdon.controller.events.EventModel;
import com.jdon.model.ModelForm;
import com.jdon.util.Debug;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public final class FormBeanUtil {
    public static final String module = FormBeanUtil.class.getName();
    public static final String FORWARD_SUCCESS_NAME = "success";
    public static final String FORWARD_FAILURE_NAME = "failure";

    public static void saveActionForm(ActionForm form, ActionMapping mapping, HttpServletRequest request) {
        if (form != null && mapping.getAttribute() != null) {
            if ("request".equals(mapping.getScope())) {
                request.setAttribute(mapping.getAttribute(), (Object)form);
            } else {
                HttpSession session = request.getSession();
                session.setAttribute(mapping.getAttribute(), (Object)form);
                request.setAttribute(mapping.getAttribute(), (Object)form);
            }
        }
    }

    public static ActionForm loadActionForm(ActionMapping mapping, HttpServletRequest request) {
        if ("request".equals(mapping.getScope())) {
            return (ActionForm)request.getAttribute(mapping.getAttribute());
        }
        HttpSession session = request.getSession();
        return (ActionForm)session.getAttribute(mapping.getAttribute());
    }

    public static ActionForm lookupActionForm(HttpServletRequest request, String formName) {
        ActionForm actionForm = null;
        actionForm = (ActionForm)request.getAttribute(formName);
        if (actionForm == null) {
            HttpSession session = request.getSession();
            actionForm = (ActionForm)session.getAttribute(formName);
        }
        return actionForm;
    }

    public static void removeActionForm(ActionMapping mapping, HttpServletRequest request) {
        if (mapping.getAttribute() != null) {
            if ("request".equals(mapping.getScope())) {
                request.removeAttribute(mapping.getAttribute());
            } else {
                HttpSession session = request.getSession();
                session.removeAttribute(mapping.getAttribute());
                request.removeAttribute(mapping.getAttribute());
            }
        }
    }

    public static String getFormName(ActionMapping mapping) throws Exception {
        String formName = "NoFormName Error!";
        if (mapping.getName() != null) {
            formName = mapping.getName();
        } else if (mapping.getAttribute() != null) {
            formName = mapping.getAttribute();
        } else {
            throw new Exception("not found the actionForm name in action configure");
        }
        return formName;
    }

    public static ModelForm getModelForm(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request) throws Exception {
        if (actionForm == null) {
            String msg = " not found the actionForm name in action configure";
            Debug.logError((String)msg);
            throw new Exception(msg);
        }
        ModelForm modelForm = null;
        try {
            modelForm = (ModelForm)actionForm;
        }
        catch (ClassCastException e) {
            String msg = "your class:" + actionForm.getClass().getName() + " isn't the subclass of com.jdon.model.ModelForm";
            Debug.logVerbose((String)msg, (String)module);
            throw new Exception(msg);
        }
        return modelForm;
    }

    public static boolean validateAction(String actionName, ActionMapping mapping) {
        boolean res = true;
        int result = FormBeanUtil.actionTransfer(actionName);
        if (result == 0) {
            res = false;
        }
        if (mapping.findForward(actionName) == null) {
            res = false;
        }
        return res;
    }

    public static String getName(HttpServletRequest request) throws Exception {
        Principal principal = request.getUserPrincipal();
        if (principal == null) {
            Debug.logError((String)"[JdonFramework] No Principal", (String)module);
            throw new Exception(" No Principal");
        }
        return principal.getName();
    }

    public static ActionErrors notNull(Object object, String errorsInfo) {
        ActionErrors errors = new ActionErrors();
        if (object == null) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(errorsInfo));
        }
        return errors;
    }

    public static EventModel createEvent(ModelForm form, Object model) throws Exception {
        EventModel em = new EventModel();
        try {
            PropertyUtils.copyProperties((Object)model, (Object)form);
            em.setModelIF(model);
            String action = form.getAction();
            em.setActionName(action);
            em.setActionType(FormBeanUtil.actionTransfer(action));
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework]create Event error:" + ex), (String)module);
            throw new Exception(ex);
        }
        return em;
    }

    public static int actionTransfer(String actionName) {
        if (actionName.equalsIgnoreCase("create")) {
            return 3;
        }
        if (actionName.equalsIgnoreCase("edit")) {
            return 2;
        }
        if (actionName.equalsIgnoreCase("update")) {
            return 2;
        }
        if (actionName.equalsIgnoreCase("delete")) {
            return 4;
        }
        return 0;
    }
}

