/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.strutsutil;

import com.jdon.container.startup.ContainerSetupScript;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.controller.context.web.ServletContextWrapper;
import com.jdon.util.Debug;
import com.jdon.util.FileLocator;
import com.jdon.util.StringUtil;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;

public class InitPlugIn
implements PlugIn {
    public static final String module = InitPlugIn.class.getName();
    private ContainerSetupScript css = new ContainerSetupScript();
    private FileLocator fileLocator = new FileLocator();
    private ActionServlet servlet = null;

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.servlet = servlet;
        ServletContext sc = servlet.getServletContext();
        ServletContextWrapper scw = new ServletContextWrapper(sc);
        String config_file = "";
        PlugInConfig[] plugInConfigs = config.findPlugInConfigs();
        int length = plugInConfigs.length;
        for (int i = 0; i < length; ++i) {
            Set entries = plugInConfigs[i].getProperties().entrySet();
            for (Map.Entry entry : entries) {
                if (!"modelmapping-config".equals(entry.getKey())) continue;
                config_file = (String)entry.getValue();
                String[] configs = StringUtil.split((String)config_file, (String)",");
                for (int j = 0; j < configs.length; ++j) {
                    if (!this.checkExsit(configs[j])) continue;
                    Debug.logVerbose((String)(" found and start config.:" + configs[j]), (String)module);
                    this.css.prepare(configs[j], (AppContextWrapper)scw);
                }
            }
        }
    }

    public boolean checkExsit(String config_file) {
        boolean ret = false;
        InputStream xmlFile = null;
        try {
            xmlFile = this.fileLocator.getConfPathXmlStream(config_file);
            if (xmlFile != null) {
                ret = true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return ret;
    }

    public void destroy() {
        this.css.destroyed((AppContextWrapper)new ServletContextWrapper(this.servlet.getServletContext()));
        this.servlet = null;
    }
}

