/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.strutsutil;

import com.jdon.controller.model.Model;
import com.jdon.controller.model.PageIterator;
import com.jdon.domain.model.cache.ModelKey;
import com.jdon.strutsutil.FormBeanUtil;
import com.jdon.strutsutil.ModelBaseAction;
import com.jdon.strutsutil.ModelListForm;
import com.jdon.util.Debug;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class ModelListAction
extends ModelBaseAction {
    private static final String module = ModelListAction.class.getName();

    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.intContext(this.getServlet().getServletContext());
            ModelListForm listForm = this.getModelListForm(actionMapping, actionForm, request);
            int start = listForm.getStart();
            int count = listForm.getCount();
            PageIterator pageIterator = this.getPageIterator(request, start, count);
            if (pageIterator != null) {
                if (pageIterator.isElementsTypeIsKey()) {
                    this.setModellistByKey(listForm, pageIterator, request);
                } else {
                    this.setModellistByModel(listForm, pageIterator, request);
                }
            } else {
                Debug.logError((String)"getPageIterator not be implemented, you must implement either of them ", (String)module);
                listForm.setList(new ArrayList());
            }
            listForm.setOneModel(this.setupOneModelIF(request));
            this.customizeListForm(actionMapping, actionForm, request, listForm);
        }
        catch (Exception e) {
            Debug.logError((Throwable)e);
            return actionMapping.findForward("failure");
        }
        if (actionMapping.findForward("success") == null) {
            Debug.logError((String)"not found the forward name 'success' in struts-config.xml", (String)module);
        }
        return actionMapping.findForward("success");
    }

    private void setModellistByKey(ModelListForm listForm, PageIterator pageIterator, HttpServletRequest request) {
        Debug.logVerbose((String)("[JdonFramework] setModellistByKey  AllCount=" + pageIterator.getAllCount()), (String)module);
        ArrayList c = null;
        try {
            listForm.setAllCount(pageIterator.getAllCount());
            if (pageIterator.getCount() != 0) {
                listForm.setCount(pageIterator.getCount());
            }
            c = this.getModelList(request, pageIterator);
            Debug.logVerbose((String)("[JdonFramework] listForm 's property: getList size is " + c.size()), (String)module);
            pageIterator.reset();
        }
        catch (Exception e) {
            Debug.logError((String)(" setModellistByKey error " + e), (String)module);
            c = new ArrayList();
        }
        listForm.setList(c);
    }

    private void setModellistByModel(ModelListForm listForm, PageIterator pageIterator, HttpServletRequest request) {
        ArrayList<Object> c = null;
        try {
            listForm.setAllCount(pageIterator.getAllCount());
            if (pageIterator.getCount() != 0) {
                listForm.setCount(pageIterator.getCount());
            }
            c = new ArrayList<Object>(pageIterator.getSize());
            while (pageIterator.hasNext()) {
                Object o = pageIterator.next();
                if (o == null) continue;
                c.add(o);
            }
            Debug.logVerbose((String)("[JdonFramework] listForm 's property: getList size is " + c.size()), (String)module);
            pageIterator.reset();
        }
        catch (Exception e) {
            Debug.logError((String)(" setModellistByModel error " + e), (String)module);
            c = new ArrayList();
        }
        listForm.setList(c);
    }

    protected ModelListForm getModelListForm(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request) throws Exception {
        ModelListForm modelListForm = null;
        if (actionForm == null) {
            modelListForm = new ModelListForm();
            FormBeanUtil.saveActionForm(modelListForm, actionMapping, request);
        } else if (actionForm instanceof ModelListForm) {
            modelListForm = (ModelListForm)actionForm;
        }
        if (modelListForm == null) {
            throw new Exception("not found the bean of com.jdon.strutsutil.ModelListForm");
        }
        return modelListForm;
    }

    protected List getModelList(HttpServletRequest request, PageIterator pageIterator) throws Exception {
        Debug.logVerbose((String)("[JdonFramework] getModelList  page size=" + pageIterator.getSize()), (String)module);
        ArrayList<Object> list = new ArrayList<Object>(pageIterator.getSize());
        Object model = null;
        Class<?> modelClass = null;
        while (pageIterator.hasNext()) {
            Object dataKey = pageIterator.next();
            if (modelClass == null || !this.isEnableCache()) {
                Debug.logVerbose((String)"[JdonFramework] getCache from db. ", (String)module);
                model = this.fetchModel(request, dataKey);
                if (model == null) continue;
                modelClass = model.getClass();
            } else {
                ModelKey modelKey = new ModelKey(dataKey, modelClass);
                model = this.modelManager.getCache(modelKey);
                if (model == null) {
                    model = this.fetchModel(request, dataKey);
                    this.modelManager.addCache(modelKey, model);
                }
            }
            if (model == null) continue;
            list.add(model);
        }
        return list;
    }

    public void customizeListForm(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, ModelListForm modelListForm) throws Exception {
    }

    protected boolean isEnableCache() {
        return true;
    }

    private Object fetchModel(HttpServletRequest request, Object dataKey) throws Exception {
        if (dataKey == null) {
            return null;
        }
        Object model = null;
        try {
            model = this.findModelIFByKey(request, dataKey);
            if (model == null) {
                Debug.logWarning((String)("[JdonFramework] the model is null for the primary key=" + dataKey + " and data type=" + dataKey.getClass().getName() + ", reasons:"), (String)module);
                Debug.logWarning((String)"[JdonFramework] 1. maybe the data in database was deleted ", (String)module);
                Debug.logWarning((String)("[JdonFramework] 2. a error occured in the findModelByKey method of the class " + ((Object)((Object)this)).getClass().getName()), (String)module);
            }
        }
        catch (Exception ex) {
            Debug.logError((Throwable)ex, (String)module);
        }
        return model;
    }

    protected Object setupOneModelIF(HttpServletRequest request) {
        return this.setupOneModel(request);
    }

    protected Model setupOneModel(HttpServletRequest request) {
        return null;
    }

    public abstract PageIterator getPageIterator(HttpServletRequest var1, int var2, int var3);

    public Object findModelIFByKey(HttpServletRequest request, Object key) {
        return this.findModelByKey(request, key);
    }

    public Model findModelByKey(HttpServletRequest request, Object key) {
        return null;
    }
}

