/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.strutsutil;

import com.jdon.controller.events.EventModel;
import com.jdon.model.ModelForm;
import com.jdon.model.ModelHandler;
import com.jdon.model.config.ModelMapping;
import com.jdon.strutsutil.FormBeanUtil;
import com.jdon.strutsutil.ModelBaseAction;
import com.jdon.util.Debug;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class ModelSaveAction
extends ModelBaseAction {
    private static final String module = ModelSaveAction.class.getName();

    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.intContext(this.getServlet().getServletContext());
        this.checkConfigName(actionMapping);
        EventModel em = null;
        String formName = FormBeanUtil.getFormName(actionMapping);
        ModelHandler modelHandler = this.modelManager.borrowtHandlerObject(formName);
        try {
            ModelForm form = this.getModelForm(modelHandler, actionForm, request);
            Object model = this.makeModel(actionMapping, actionForm, request, modelHandler);
            modelHandler.formCopyToModelIF(form, model);
            em = new EventModel();
            em.setActionName(form.getAction());
            em.setModelIF(model);
            em.setActionType(FormBeanUtil.actionTransfer(form.getAction()));
            Debug.logVerbose((String)"[JdonFramework] save data to database ... ", (String)module);
            modelHandler.serviceAction(em, request);
            modelHandler.modelIFCopyToForm(em.getModelIF(), form);
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework]please check your service \u3001 model or form :" + ex), (String)module);
            throw new Exception("System error! please call system Admin." + ex);
        }
        finally {
            this.modelManager.returnHandlerObject(modelHandler);
        }
        if (em.getErrors() != null) {
            Debug.logError((String)("[JdonFramework] save error!! " + em.getErrors()), (String)module);
            ActionMessages errors = new ActionMessages();
            ActionMessage error = new ActionMessage(em.getErrors());
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
            this.saveErrors(request, errors);
            ActionForward af = actionMapping.findForward("failure");
            if (af != null) {
                return af;
            }
            return actionMapping.findForward("success");
        }
        Debug.logVerbose((String)"[JdonFramework] save successfully ... ", (String)module);
        return actionMapping.findForward("success");
    }

    protected ModelForm getModelForm(ModelHandler modelHandler, ActionForm actionForm, HttpServletRequest request) throws Exception {
        if (actionForm == null) {
            throw new Exception(" must define form-bean as 'action' name in struts-config.xml ");
        }
        ModelForm strutsForm = (ModelForm)actionForm;
        String action = strutsForm.getAction();
        if (action == null || action.length() == 0) {
            throw new Exception(" Need a field : <html:hidden property=action /> in jsp's form! ");
        }
        return strutsForm;
    }

    protected Object makeModel(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, ModelHandler modelHandler) throws Exception {
        Object model = null;
        try {
            String formName = actionMapping.getName();
            if (formName == null) {
                throw new Exception("no define the FormName in struts_config.xml");
            }
            ModelMapping modelMapping = modelHandler.getModelMapping();
            String keyName = modelMapping.getKeyName();
            String keyValue = request.getParameter(keyName);
            if (keyValue == null) {
                Debug.logError((String)"[JdonFramework]Need a model's key field : <html:hidden property=MODEL KEY /> in jsp's form! ", (String)module);
            }
            this.modelManager.removeCache((Object)keyValue);
            Debug.logVerbose((String)("[JdonFramework] no model cache, keyName is " + keyName), (String)module);
            model = this.modelManager.getModelObject(formName);
        }
        catch (Exception e) {
            Debug.logError((String)("[JdonFramework] makeModel error: " + e));
            throw new Exception(e);
        }
        return model;
    }
}

