/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.strutsutil;

import com.jdon.controller.WebAppUtil;
import com.jdon.controller.events.EventModel;
import com.jdon.controller.model.ModelUtil;
import com.jdon.model.ModelForm;
import com.jdon.model.ModelHandler;
import com.jdon.model.handler.HandlerMetaDef;
import com.jdon.strutsutil.FormBeanUtil;
import com.jdon.strutsutil.ModelBaseAction;
import com.jdon.util.Debug;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class ServiceMethodAction
extends ModelBaseAction {
    private static final String module = ServiceMethodAction.class.getName();

    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.intContext(this.getServlet().getServletContext());
        ModelForm modelForm = (ModelForm)actionForm;
        if (modelForm == null || modelForm.getMethod() == null) {
            Debug.logError((String)"[JdonFramework] no form or no action/method ", (String)module);
            return actionMapping.findForward("forward");
        }
        String formName = FormBeanUtil.getFormName(actionMapping);
        Debug.logVerbose((String)("[JdonFramework]--> enter ServiceMethodAction, formName = " + formName), (String)module);
        ModelHandler modelHandler = this.modelManager.borrowtHandlerObject(formName);
        EventModel em = new EventModel();
        try {
            Object modelDTO = this.modelManager.getModelObject(formName);
            modelHandler.formCopyToModelIF(modelForm, modelDTO);
            HandlerMetaDef hm = modelHandler.getModelMapping().getHandlerMetaDef();
            String serviceName = hm.getServiceRef();
            em.setActionName(modelForm.getMethod());
            em.setModelIF(modelDTO);
            Object result = WebAppUtil.callService((String)serviceName, (String)modelForm.getMethod(), (Object[])new Object[]{em}, (HttpServletRequest)request);
            if (ModelUtil.isModel((Object)result)) {
                modelDTO = result;
                modelHandler.modelIFCopyToForm(modelDTO, modelForm);
            } else if (result != null) {
                request.setAttribute(result.getClass().getSimpleName(), result);
            }
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework]please check your service \u3001 model or form :" + ex), (String)module);
            throw new Exception("System error! please call system Admin." + ex);
        }
        finally {
            this.modelManager.returnHandlerObject(modelHandler);
        }
        if (em.getErrors() != null) {
            Debug.logError((String)("[JdonFramework] error happend " + em.getErrors()), (String)module);
            ActionMessages errors = new ActionMessages();
            ActionMessage error = new ActionMessage(em.getErrors());
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
            this.saveErrors(request, errors);
        }
        ActionForward sucessaf = actionMapping.findForward("success");
        ActionForward actionnameaf = actionMapping.findForward(modelForm.getAction());
        if (sucessaf != null) {
            return sucessaf;
        }
        if (actionnameaf != null) {
            return actionnameaf;
        }
        Debug.logError((String)"[JdonFramework] forward name is not 'success'", (String)module);
        return null;
    }
}

