/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.strutsutil.file;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.upload.FormFile;

public class MultiImageForm
extends ActionForm {
    private static final long serialVersionUID = -1485700498155979477L;
    public static final String module = MultiImageForm.class.getName();
    private static String ERROR_PROPERTY_MAX_LENGTH_EXCEEDED = "com.jdon.strutsutil.file.MaxLengthExceeded";
    public static int MAX_IMAGES_COUNT = 2;
    private Map fileMap = new HashMap();
    private Map nameMap = new HashMap();

    public FormFile getFile(int index) {
        return (FormFile)this.fileMap.get(new Integer(index));
    }

    public void setFile(int index, FormFile file) {
        this.fileMap.put(new Integer(index), file);
    }

    public FormFile[] getFiles() {
        return this.fileMap.values().toArray(new FormFile[this.fileMap.size()]);
    }

    public String getName(int index) {
        return (String)this.nameMap.get(new Integer(index));
    }

    public void setName(int index, String name) {
        this.nameMap.put(new Integer(index), name);
    }

    public String[] getNames() {
        return this.nameMap.values().toArray(new String[0]);
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = null;
        Boolean maxLengthExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded");
        if (maxLengthExceeded != null && maxLengthExceeded.booleanValue()) {
            errors = new ActionErrors();
            errors.add(ERROR_PROPERTY_MAX_LENGTH_EXCEEDED, new ActionMessage("maxLengthExceeded"));
        } else if (this.fileMap.size() > MAX_IMAGES_COUNT) {
            errors = new ActionErrors();
            errors.add(ERROR_PROPERTY_MAX_LENGTH_EXCEEDED, new ActionMessage("maxLengthExceeded"));
        } else {
            for (FormFile file : this.fileMap.values()) {
                String fileName = file.getFileName();
                if (fileName.toLowerCase().endsWith(".gif") || fileName.toLowerCase().endsWith(".jpg") || fileName.toLowerCase().endsWith(".png")) continue;
                errors = new ActionErrors();
                errors.add("notImage", new ActionMessage("notImage"));
            }
        }
        return errors;
    }
}

