/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.strutsutil.file;

import com.jdon.strutsutil.file.MultiImageForm;
import com.jdon.strutsutil.file.UploadFile;
import com.jdon.strutsutil.file.filter.ImageSessionFilter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;

public class MultiUploadAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (form == null) {
            throw new Exception("please setup UploadImageForm in struts-config.xml");
        }
        MultiImageForm theForm = (MultiImageForm)form;
        FormFile[] files = theForm.getFiles();
        int length = files.length;
        ImageSessionFilter imageFilter = new ImageSessionFilter();
        UploadFile uploadFile = null;
        for (int i = 0; i < length; ++i) {
            uploadFile = this.doFormFile(request, files[i]);
            uploadFile.setName(theForm.getNames()[i]);
            imageFilter.addUploadFile(request, uploadFile);
        }
        return mapping.findForward("display");
    }

    private UploadFile doFormFile(HttpServletRequest request, FormFile file) throws Exception {
        UploadFile uploadFile = new UploadFile();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream stream = file.getInputStream();
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] data = baos.toByteArray();
            baos.close();
            stream.close();
            if (data != null) {
                uploadFile.setData(data);
                uploadFile.setContentType(file.getContentType());
                uploadFile.setSize(file.getFileSize());
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        finally {
            file.destroy();
        }
        return uploadFile;
    }
}

