/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.strutsutil.file.filter;

import com.jdon.strutsutil.file.UploadFile;
import com.jdon.strutsutil.file.filter.ImageFilter;
import com.jdon.util.Debug;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;

public class ImageCacheFilter
implements ImageFilter {
    public static final String module = ImageCacheFilter.class.getName();
    private ImageFilter imageFilter = null;

    public ImageCacheFilter(ImageFilter imageFilter) {
        this.imageFilter = imageFilter;
    }

    public Collection getUploadFileID(HttpServletRequest request) {
        Debug.logVerbose((String)"[JdonFramework]--> enter cache filter ", (String)module);
        Collection uploadIDList = null;
        try {
            uploadIDList = this.imageFilter.getUploadFileID(request);
        }
        catch (Exception ex) {
            Debug.logError((String)"[JdonFramework] not found the upload files in session", (String)module);
        }
        return uploadIDList;
    }

    public UploadFile getUploadFile(HttpServletRequest request, String id) {
        Debug.logVerbose((String)"[JdonFramework]--> enter cache filter ", (String)module);
        UploadFile uploadFile = null;
        try {
            if (uploadFile == null) {
                uploadFile = this.imageFilter.getUploadFile(request, id);
            }
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework]getData error:" + ex), (String)module);
        }
        return uploadFile;
    }

    public void deleteUploadFile(HttpServletRequest request, UploadFile uploadFile) {
        try {
            this.imageFilter.deleteUploadFile(request, uploadFile);
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework] deleteUploadFile error" + ex), (String)module);
        }
    }

    public void addUploadFile(HttpServletRequest request, UploadFile uploadFile) {
    }

    public Collection loadAllUploadFile(HttpServletRequest request) {
        return null;
    }
}

