/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.strutsutil.file.filter;

import com.jdon.strutsutil.file.UploadFile;
import com.jdon.strutsutil.file.filter.ImageFilter;
import com.jdon.util.Debug;
import com.jdon.util.UtilValidate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ImageSessionFilter
implements ImageFilter {
    public static final String module = ImageSessionFilter.class.getName();
    private static final String PIC_NAME_PACKAGE = "PicturesPakage";
    private ImageFilter imageFilter = null;

    public ImageSessionFilter(ImageFilter imageFilter) {
        this.imageFilter = imageFilter;
    }

    public ImageSessionFilter() {
    }

    public Collection getUploadFileID(HttpServletRequest request) {
        LinkedHashSet<String> set = null;
        Debug.logVerbose((String)"[JdonFramework]--> enter session filter ", (String)module);
        try {
            Collection list = this.imageFilter.getUploadFileID(request);
            set = list == null ? new LinkedHashSet<String>() : new LinkedHashSet(list);
            HttpSession session = request.getSession();
            Collection sessionList = (Collection)session.getAttribute(PIC_NAME_PACKAGE);
            if (sessionList == null) {
                return set;
            }
            for (UploadFile uploadFile : sessionList) {
                if (uploadFile.getId() != null && !uploadFile.getId().equals("")) {
                    set.add(uploadFile.getId());
                    continue;
                }
                set.add(uploadFile.getTempId());
            }
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework] getUploadFileID error" + ex), (String)module);
        }
        return set;
    }

    public UploadFile getUploadFile(HttpServletRequest request, String id) {
        UploadFile uploadFile = null;
        Debug.logVerbose((String)("[JdonFramework]--> getUploadFile session filter id=" + id), (String)module);
        try {
            uploadFile = this.getUploadFileFromSession(request, id);
            if (uploadFile == null) {
                uploadFile = this.imageFilter.getUploadFile(request, id);
            }
        }
        catch (Exception ex) {
            Debug.logWarning((String)(" getUploadFile error" + ex), (String)module);
        }
        return uploadFile;
    }

    public void deleteUploadFile(HttpServletRequest request, UploadFile uploadFile) {
        block4: {
            try {
                String imageId = null;
                if (!UtilValidate.isEmpty((String)uploadFile.getTempId())) {
                    imageId = uploadFile.getTempId();
                    this.deleteUploadFileFromSession(request, imageId);
                    break block4;
                }
                if (!UtilValidate.isEmpty((String)uploadFile.getId())) {
                    imageId = uploadFile.getId();
                    this.deleteUploadFileFromSession(request, imageId);
                    this.imageFilter.deleteUploadFile(request, uploadFile);
                    break block4;
                }
                throw new Exception("parameter id  and tempId all is null");
            }
            catch (Exception ex) {
                Debug.logError((String)("[JdonFramework] deleteUploadFile error:" + ex), (String)module);
            }
        }
    }

    public void addUploadFile(HttpServletRequest request, UploadFile uploadFile) {
        if (uploadFile == null) {
            return;
        }
        try {
            HttpSession session = request.getSession(true);
            ArrayList<UploadFile> uploadList = (ArrayList<UploadFile>)session.getAttribute(PIC_NAME_PACKAGE);
            if (uploadList == null) {
                uploadList = new ArrayList<UploadFile>();
                session.setAttribute(PIC_NAME_PACKAGE, uploadList);
            }
            uploadList.add(uploadFile);
            uploadFile.setTempId(Integer.toString(uploadList.size() - 1));
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework]addUploadFile error:" + ex), (String)module);
        }
    }

    public Collection loadAllUploadFile(HttpServletRequest request) {
        Debug.logVerbose((String)"[JdonFramework] load all upload files from session and remove them", (String)module);
        Collection uploadList = null;
        try {
            HttpSession session = request.getSession();
            if (session != null) {
                uploadList = (Collection)session.getAttribute(PIC_NAME_PACKAGE);
                session.removeAttribute(PIC_NAME_PACKAGE);
            }
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework] not found the upload files in session" + ex), (String)module);
        }
        return uploadList;
    }

    public Collection getAllUploadFile(HttpServletRequest request) {
        Collection uploadList = null;
        try {
            HttpSession session = request.getSession();
            if (session != null) {
                uploadList = (Collection)session.getAttribute(PIC_NAME_PACKAGE);
            }
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework] not found the upload files in session" + ex), (String)module);
        }
        return uploadList;
    }

    private UploadFile getUploadFileFromSession(HttpServletRequest request, String id) {
        UploadFile uploadFile2 = null;
        boolean found = false;
        try {
            HttpSession session = request.getSession(true);
            Collection uploadList = (Collection)session.getAttribute(PIC_NAME_PACKAGE);
            if (uploadList == null) {
                return null;
            }
            for (UploadFile uploadFile2 : uploadList) {
                if (uploadFile2.getId().equals(id)) {
                    found = true;
                    break;
                }
                if (!uploadFile2.getTempId().equals(id)) continue;
                found = true;
                break;
            }
            if (!found) {
                uploadFile2 = null;
            }
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework] getUploadFileSession error" + ex), (String)module);
        }
        return uploadFile2;
    }

    private void deleteUploadFileFromSession(HttpServletRequest request, String id) {
        try {
            HttpSession session = request.getSession(true);
            Collection uploadList = (Collection)session.getAttribute(PIC_NAME_PACKAGE);
            if (uploadList == null || id == null) {
                return;
            }
            UploadFile uploadFile = null;
            boolean found = false;
            for (Object o : uploadList) {
                Debug.logError((String)("[JdonFramework] object: " + o.getClass().getName()), (String)module);
                uploadFile = (UploadFile)((Object)o);
                if (uploadFile.getId().equals(id)) {
                    found = true;
                    break;
                }
                if (!uploadFile.getTempId().equals(id)) continue;
                found = true;
                break;
            }
            if (found) {
                uploadList.remove((Object)uploadFile);
            }
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework] deleteUploadFileFromSession error" + ex), (String)module);
        }
    }
}

