/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.strutsutil.treeview;

import com.jdon.strutsutil.treeview.TreeControl;
import com.jdon.strutsutil.treeview.ViewNode;
import com.jdon.util.Debug;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class TreeAction
extends Action {
    private static final String module = TreeAction.class.getName();

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TreeControl control = this.getTreeControl(request);
        if (control.getRoot() == null) {
            if (request.getParameterMap().containsKey("init")) {
                this.initRoot(request);
            } else {
                Debug.logError((String)"[JdonFramework]please init the tree at first !");
            }
        } else {
            this.refreshTree(request, control);
        }
        return mapping.findForward("tree-control");
    }

    private TreeControl getTreeControl(HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession();
        TreeControl control = (TreeControl)session.getAttribute("tree-control");
        try {
            if (control == null || request.getParameterMap().isEmpty()) {
                Debug.logVerbose((String)"[JdonFramework] get tree from db..", (String)module);
                ViewNode root = this.getRootViewNode(request);
                control = new TreeControl(root);
                this.fetchRootChildern(request, root);
                session.setAttribute("tree-control", (Object)control);
            }
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework] getTreeControl error: " + ex), (String)module);
        }
        return control;
    }

    private ViewNode getRootViewNode(HttpServletRequest request) throws Exception {
        String rooNodeID = this.getRootNodeID(request);
        if (rooNodeID == null) {
            Debug.logError((String)"[JdonFramework] root Id is null ! ", (String)module);
            return null;
        }
        Debug.logVerbose((String)("[JdonFramework] get the tree's root Node: " + rooNodeID), (String)module);
        ViewNode rNode = new ViewNode(rooNodeID, rooNodeID, true);
        rNode.setRoot(true);
        return rNode;
    }

    public void fetchRootChildern(HttpServletRequest request, ViewNode root) throws Exception {
        Collection childernNodeOfRoot = null;
        try {
            childernNodeOfRoot = this.getRootChildern(request);
            for (ViewNode nodeChild : childernNodeOfRoot) {
                root.addChild(nodeChild);
            }
        }
        catch (Exception ex) {
            Debug.logError((Throwable)ex, (String)module);
            throw new Exception(" tree not init ");
        }
    }

    private void refreshTree(HttpServletRequest request, TreeControl control) throws Exception {
        String select;
        String key = request.getParameter("key");
        if (key != null) {
            ViewNode node = control.findNode(key);
            if (node != null) {
                Debug.logVerbose((String)("[JdonFramework]Found Node: " + key), (String)module);
                if (!node.isExpanded()) {
                    node.clearChildren();
                    this.fetchChildern(request, node);
                }
                node.setExpanded(!node.isExpanded());
            } else {
                Debug.logVerbose((String)("[JdonFramework]Node is null : " + key));
            }
        }
        if ((select = request.getParameter("select")) != null) {
            control.selectNode(select);
        }
    }

    public void fetchChildern(HttpServletRequest request, ViewNode node) {
        Collection childernNode = null;
        try {
            childernNode = this.getChildern(request, node);
            for (ViewNode nodeChild : childernNode) {
                node.addChild(nodeChild);
            }
        }
        catch (Exception ex) {
            Debug.logError((Throwable)ex, (String)module);
        }
    }

    public abstract Collection getRootChildern(HttpServletRequest var1) throws Exception;

    public abstract String getRootNodeID(HttpServletRequest var1) throws Exception;

    public abstract void initRoot(HttpServletRequest var1) throws Exception;

    public abstract Collection getChildern(HttpServletRequest var1, ViewNode var2) throws Exception;
}

