/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.strutsutil.treeview;

import com.jdon.strutsutil.treeview.ViewNode;
import java.io.Serializable;
import java.util.HashMap;

public class TreeControl
implements Serializable {
    private static final long serialVersionUID = -5384472151297891954L;
    public static boolean init = true;
    private ViewNode selected = null;
    private ViewNode root = null;
    private HashMap registry = new HashMap();

    public TreeControl(ViewNode root) {
        this.root = root;
        root.setTree(this);
        root.setLast(true);
    }

    public ViewNode getRoot() {
        return this.root;
    }

    public ViewNode findNode(String key) {
        return (ViewNode)this.registry.get(key);
    }

    public void selectNode(String key) {
        if (this.selected != null) {
            this.selected.setSelected(false);
            this.selected = null;
        }
        this.selected = this.findNode(key);
        if (this.selected != null) {
            this.selected.setSelected(true);
        }
    }

    public void addNode(ViewNode node) throws IllegalArgumentException {
        node.setTree(this);
        this.registry.put(node.getKey(), node);
    }

    public int getTreeWidth() {
        if (this.root == null) {
            return 0;
        }
        return this.getWidth(this.root);
    }

    public int getWidth(ViewNode node) {
        int width = node.getDepth();
        ViewNode[] children = node.findChildren();
        for (int i = 0; i < children.length; ++i) {
            int current = this.getWidth(children[i]);
            if (current <= width) continue;
            width = current;
        }
        return width;
    }
}

