/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.strutsutil.treeview;

import com.jdon.strutsutil.treeview.TreeControl;
import com.jdon.strutsutil.treeview.ViewNode;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class TreeControlTag
extends TagSupport {
    private static final long serialVersionUID = -2869394702697666412L;
    private static final String DEFAULT_IMAGES = "images";
    public static final String TREE_NAME = "tree-control";
    public static final String TREE_NAME_INIT = "tree-control-init";
    private static final String CSS_STYLE = "tree-control";
    private static final String CSS_STYLE_SELECTED = "tree-control-selected";
    private static final String CSS_STYLE_UN_SELECTED = "tree-control-unselected";
    private static final String IMAGE_HANDLE_DOWN_LAST = "handledownlast.gif";
    private static final String IMAGE_HANDLE_DOWN_MIDDLE = "handledownmiddle.gif";
    private static final String IMAGE_HANDLE_RIGHT_LAST = "handlerightlast.gif";
    private static final String IMAGE_HANDLE_RIGHT_MIDDLE = "handlerightmiddle.gif";
    private static final String IMAGE_LINE_LAST = "linelastnode.gif";
    private static final String IMAGE_LINE_MIDDLE = "linemiddlenode.gif";
    private static final String IMAGE_LINE_VERTICAL = "linevertical.gif";
    protected String treeAction = null;
    protected String nodeAction = null;
    protected String target = null;
    protected String images = "images";

    public String getTreeAction() {
        return this.treeAction;
    }

    public void setTreeAction(String treeAction) {
        this.treeAction = treeAction;
    }

    public String getNodeAction() {
        return this.nodeAction;
    }

    public void setNodeAction(String nodeAction) {
        this.nodeAction = nodeAction;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getImages() {
        return this.images;
    }

    public void setImages(String images) {
        this.images = images;
    }

    public int doEndTag() throws JspException {
        TreeControl treeControl = (TreeControl)this.pageContext.findAttribute("tree-control");
        JspWriter out = this.pageContext.getOut();
        try {
            if (treeControl == null) {
                out.print("Please login again, or refresh again");
                return 6;
            }
            out.print("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"");
            out.print(" class=\"");
            out.print("tree-control");
            out.print("\"");
            out.println(">");
            int level = 0;
            ViewNode rootNode = treeControl.getRoot();
            this.render(out, rootNode, level, treeControl.getTreeWidth(), true);
            out.println("</table>");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        catch (Exception e) {
            throw new JspException("Please refresh this page!");
        }
        return 6;
    }

    protected void render(JspWriter out, ViewNode node, int level, int width, boolean last) throws IOException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String url_Path = request.getContextPath();
        if (node.isRoot()) {
            ViewNode[] children = node.findChildren();
            int lastIndex = children.length - 1;
            int newLevel = level + 1;
            for (int i = 0; i < children.length; ++i) {
                this.render(out, children[i], newLevel, width, i == lastIndex);
            }
            return;
        }
        out.println("  <tr valign=\"middle\">");
        for (int i = 0; i < level; ++i) {
            int levels = level - i;
            ViewNode parent = node;
            for (int j = 1; j <= levels; ++j) {
                parent = parent.getParent();
            }
            if (parent.isLast()) {
                out.print("    <td></td>");
            } else {
                out.print("    <td><img src=\"");
                out.print(this.images);
                out.print("/");
                out.print(IMAGE_LINE_VERTICAL);
                out.print("\" alt=\"\" border=\"0\"></td>");
            }
            out.println();
        }
        this.displayNodePic(out, node, url_Path);
        this.displayNode(out, node, url_Path, level, width);
        out.println("  </tr>");
        if (node.isExpanded()) {
            ViewNode[] children = node.findChildren();
            int lastIndex = children.length - 1;
            int newLevel = level + 1;
            for (int i = 0; i < children.length; ++i) {
                this.render(out, children[i], newLevel, width, i == lastIndex);
            }
        }
    }

    private void displayNodePic(JspWriter out, ViewNode node, String url_Path) throws IOException {
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        StringBuffer url = new StringBuffer(url_Path);
        url.append(this.treeAction);
        if (this.treeAction.indexOf("?") < 0) {
            url.append("?");
        } else {
            url.append("&");
        }
        url.append("key=").append(node.getKey());
        out.print("    <td>");
        if (this.nodeAction != null && !node.isLeaf()) {
            out.print("<a href=\"");
            out.print(response.encodeURL(url.toString()));
            out.print("\">");
        }
        out.print("<img src=\"");
        out.print(this.images);
        out.print("/");
        if (node.isLeaf()) {
            if (node.isLast()) {
                out.print(IMAGE_LINE_LAST);
            } else {
                out.print(IMAGE_LINE_MIDDLE);
            }
            out.print("\" alt=\"");
        } else if (node.isExpanded()) {
            if (node.isLast()) {
                out.print(IMAGE_HANDLE_DOWN_LAST);
            } else {
                out.print(IMAGE_HANDLE_DOWN_MIDDLE);
            }
            out.print("\" alt=\"close node");
        } else {
            if (node.isLast()) {
                out.print(IMAGE_HANDLE_RIGHT_LAST);
            } else {
                out.print(IMAGE_HANDLE_RIGHT_MIDDLE);
            }
            out.print("\" alt=\"expand node");
        }
        out.print("\" border=\"0\">");
        if (this.nodeAction != null && !node.isLeaf()) {
            out.print("</a>");
        }
        out.println("</td>");
    }

    private void displayNode(JspWriter out, ViewNode node, String url_Path, int level, int width) throws IOException {
        String encodedNodeKey = URLEncoder.encode(node.getKey(), "UTF-8");
        String action = this.replace(this.nodeAction, "${key}", encodedNodeKey);
        StringBuffer url = new StringBuffer(url_Path);
        url.append(action);
        if (this.nodeAction.indexOf("?") < 0) {
            url.append("?");
        } else {
            url.append("&");
        }
        url.append("key=").append(node.getKey());
        String treeNodeAction = url.toString();
        url = new StringBuffer(url_Path);
        url.append(this.treeAction);
        if (this.treeAction.indexOf("?") < 0) {
            url.append("?");
        } else {
            url.append("&");
        }
        url.append("select=").append(node.getKey());
        String updateNodeAction = url.toString();
        out.print("    <td colspan=\"");
        out.print(width - level + 1);
        out.print("\">");
        if (node.getLabel() != null) {
            String labelStyle = null;
            if (node.isSelected()) {
                labelStyle = CSS_STYLE_SELECTED;
            } else if (!node.isSelected()) {
                labelStyle = CSS_STYLE_UN_SELECTED;
            }
            if (treeNodeAction != null) {
                out.print(" <a href=\"");
                out.print(treeNodeAction);
                out.print("\"");
                if (this.target != null) {
                    out.print(" target=\"");
                    out.print(this.target);
                    out.print("\"");
                }
                if (labelStyle != null) {
                    out.print(" class=\"");
                    out.print(labelStyle);
                    out.print("\"");
                }
                out.print(" onclick=\"");
                out.print("self.location.href='" + updateNodeAction + "'");
                out.print("\"");
                out.print(">");
            } else if (labelStyle != null) {
                out.print("<span class=\"");
                out.print(labelStyle);
                out.print("\">");
            }
            out.print(node.getLabel());
            if (treeNodeAction != null) {
                out.print("</a>");
            } else if (labelStyle != null) {
                out.print("</span>");
            }
        }
        out.println("</td>");
    }

    protected String replace(String template, String placeholder, String value) {
        int index;
        if (template == null) {
            return null;
        }
        if (placeholder == null || value == null) {
            return template;
        }
        while ((index = template.indexOf(placeholder)) >= 0) {
            StringBuffer temp = new StringBuffer(template.substring(0, index));
            temp.append(value);
            temp.append(template.substring(index + placeholder.length()));
            template = temp.toString();
        }
        return template;
    }
}

