/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.strutsutil.treeview;

import com.jdon.strutsutil.treeview.TreeControl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ViewNode
implements Serializable {
    private static final long serialVersionUID = 3056749981121534528L;
    private boolean last = false;
    private boolean leaf = false;
    private boolean selected = false;
    private boolean expanded = false;
    private ViewNode parent = null;
    private int depth = 0;
    private TreeControl tree = null;
    private List children = new ArrayList();
    protected String key = null;
    protected String label = null;
    protected boolean root = false;

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setTree(TreeControl tree) {
        this.tree = tree;
    }

    public void clearChildren() {
        this.children.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewNode[] findChildren() {
        List list = this.children;
        synchronized (list) {
            ViewNode[] results = new ViewNode[this.children.size()];
            return this.children.toArray(results);
        }
    }

    public void addChild(ViewNode child) throws IllegalArgumentException {
        this.tree.addNode(child);
        child.setParent(this);
        this.leaf = false;
        int n = this.children.size();
        if (n > 0) {
            ViewNode node = (ViewNode)this.children.get(n - 1);
            node.setLast(false);
        }
        child.setLast(true);
        this.children.add(child);
    }

    public ViewNode getParent() {
        return this.parent;
    }

    public void setParent(ViewNode parent) {
        this.parent = parent;
        this.depth = parent == null ? 1 : parent.getDepth() + 1;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public ViewNode(String key, String label, boolean leaf) {
        this.key = key;
        this.label = label;
        this.leaf = leaf;
    }
}

