/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.strutsutil.util;

import com.jdon.controller.events.EventModel;
import com.jdon.model.ModelForm;
import com.jdon.model.ModelHandler;
import com.jdon.model.ModelHandlerManager;
import com.jdon.strutsutil.FormBeanUtil;
import com.jdon.util.Debug;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class CreateViewPageUtil {
    private static final String module = CreateViewPageUtil.class.getName();
    private ModelHandlerManager modelManager;

    public CreateViewPageUtil(ModelHandlerManager modelManager) {
        this.modelManager = modelManager;
    }

    public void doCreate(ActionMapping actionMapping, ModelForm modelForm, HttpServletRequest request) throws Exception {
        Debug.logVerbose((String)"[JdonFramework] enter doCreate... ", (String)module);
        String formName = FormBeanUtil.getFormName(actionMapping);
        ModelHandler modelHandler = this.modelManager.borrowtHandlerObject(formName);
        try {
            ModelForm form = modelHandler.initForm(request);
            if (form != null) {
                form.setAction("create");
                FormBeanUtil.saveActionForm((ActionForm)form, actionMapping, request);
            } else {
                form = modelForm;
            }
            Debug.logVerbose((String)"[JdonFramework] got a ModelForm ... ", (String)module);
            Object modelDTO = this.modelManager.getModelObject(formName);
            modelHandler.formCopyToModelIF(form, modelDTO);
            EventModel em = new EventModel();
            em.setActionName(form.getAction());
            em.setModelIF(modelDTO);
            modelDTO = this.initModel(em, request, modelHandler, form);
            if (modelDTO != null) {
                Debug.logVerbose((String)"[JdonFramework] got a Model From the 'initModel' method of the service", (String)module);
                modelHandler.modelIFCopyToForm(modelDTO, form);
            }
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework]please check your service \u3001 model or form, error is: " + ex), (String)module);
            throw new Exception("System error! please call system admin. " + ex);
        }
        finally {
            this.modelManager.returnHandlerObject(modelHandler);
        }
    }

    private Object initModel(EventModel em, HttpServletRequest request, ModelHandler modelHandler, ModelForm form) throws Exception {
        Object model = null;
        try {
            model = modelHandler.initModelIF(em, form, request);
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework] the method 'initForm' of your handler or 'initMethod' of your service happened error: " + ex), (String)module);
            throw new Exception(ex);
        }
        return model;
    }
}

