/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.model.query;

import com.jdon.cache.LRUCache;
import com.jdon.controller.cache.Cache;
import com.jdon.controller.cache.CacheManager;
import com.jdon.controller.model.PageIterator;
import com.jdon.model.query.JdbcTemp;
import com.jdon.model.query.block.Block;
import com.jdon.model.query.block.BlockQueryJDBC;
import com.jdon.model.query.block.BlockQueryJDBCTemp;
import com.jdon.model.query.block.BlockStrategy;
import com.jdon.model.query.cache.BlockCacheManager;
import com.jdon.model.query.cache.QueryConditonDatakey;
import com.jdon.util.Debug;
import com.jdon.util.UtilValidate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;

public class PageIteratorSolver {
    private static final String module = PageIteratorSolver.class.getName();
    private BlockQueryJDBC blockQueryJDBC;
    private final JdbcTemp jdbcTemp;
    private final BlockCacheManager blockCacheManager;
    private BlockStrategy blockStrategy;
    private boolean cacheEnable = true;

    public PageIteratorSolver(DataSource dataSource, CacheManager cacheManager) {
        this.blockQueryJDBC = new BlockQueryJDBCTemp(dataSource);
        this.jdbcTemp = new JdbcTemp(dataSource);
        this.blockCacheManager = new BlockCacheManager(cacheManager);
        this.blockStrategy = new BlockStrategy(this.blockQueryJDBC, this.blockCacheManager);
    }

    public PageIteratorSolver(DataSource dataSource, CacheManager cacheManager, BlockStrategy blockStrategy) {
        this(dataSource, cacheManager);
        this.blockStrategy = blockStrategy;
    }

    public PageIteratorSolver(DataSource dataSource) {
        this.blockQueryJDBC = new BlockQueryJDBCTemp(dataSource);
        this.jdbcTemp = new JdbcTemp(dataSource);
        CacheManager cacheManager = new CacheManager((Cache)new LRUCache("cache.xml"));
        this.blockCacheManager = new BlockCacheManager(cacheManager);
        this.blockStrategy = new BlockStrategy(this.blockQueryJDBC, this.blockCacheManager);
    }

    public Object querySingleObject(Collection queryParams, String sqlquery) throws Exception {
        return this.jdbcTemp.querySingleObject(queryParams, sqlquery);
    }

    public List queryMultiObject(Collection queryParams, String sqlquery) throws Exception {
        return this.jdbcTemp.queryMultiObject(queryParams, sqlquery);
    }

    public PageIterator getDatas(String queryParam, String sqlqueryAllCount, String sqlquery, int start, int count) {
        if (UtilValidate.isEmpty((String)sqlqueryAllCount)) {
            Debug.logError((String)" the parameter sqlqueryAllCount is null", (String)module);
            return new PageIterator();
        }
        if (UtilValidate.isEmpty((String)sqlquery)) {
            Debug.logError((String)" the parameter sqlquery is null", (String)module);
            return new PageIterator();
        }
        ArrayList<String> queryParams = new ArrayList<String>();
        if (!UtilValidate.isEmpty((String)queryParam)) {
            queryParams.add(queryParam);
        }
        return this.getPageIterator(sqlqueryAllCount, sqlquery, queryParams, start, count);
    }

    public PageIterator getPageIterator(String sqlqueryAllCount, String sqlquery, String queryParam, int start, int count) {
        if (UtilValidate.isEmpty((String)sqlqueryAllCount)) {
            Debug.logError((String)" the parameter sqlqueryAllCount is null", (String)module);
            return new PageIterator();
        }
        if (UtilValidate.isEmpty((String)sqlquery)) {
            Debug.logError((String)" the parameter sqlquery is null", (String)module);
            return new PageIterator();
        }
        return this.getDatas(queryParam, sqlqueryAllCount, sqlquery, start, count);
    }

    public PageIterator getPageIterator(String sqlqueryAllCount, String sqlquery, Collection queryParams, int startIndex, int count) {
        Block currentBlock;
        Debug.logVerbose((String)("[JdonFramework]enter getPageIterator .. start= " + startIndex + " count=" + count), (String)module);
        if (queryParams == null) {
            Debug.logError((String)" the parameters collection is null", (String)module);
            return new PageIterator();
        }
        if (count > this.blockStrategy.getBlockLength() || count <= 0) {
            count = this.blockStrategy.getBlockLength();
        }
        if ((currentBlock = this.getBlock(sqlquery, queryParams, startIndex, count)) == null) {
            return new PageIterator();
        }
        startIndex = currentBlock.getStart();
        int endIndex = startIndex + currentBlock.getCount();
        Object[] keys = currentBlock.getList().toArray();
        int allCount = this.getDatasAllCount(queryParams, sqlqueryAllCount);
        Debug.logVerbose((String)("[JdonFramework]currentBlock: startIndex=" + startIndex + " endIndex=" + endIndex + " keys length=" + keys.length), (String)module);
        if (endIndex < startIndex) {
            Debug.logWarning((String)"WARNNING : endIndex < startIndex", (String)module);
            return new PageIterator();
        }
        return new PageIterator(allCount, keys, startIndex, endIndex, count);
    }

    public Block locate(String sqlquery, Collection queryParams, Object locateId) {
        return this.blockStrategy.locate(sqlquery, queryParams, locateId);
    }

    public Block getBlock(String sqlquery, Collection queryParams, int startIndex, int count) {
        return this.blockStrategy.getBlock(sqlquery, queryParams, startIndex, count);
    }

    public int getDatasAllCount(String queryParam, String sqlquery) {
        ArrayList<String> queryParams = new ArrayList<String>();
        queryParams.add(queryParam);
        return this.getDatasAllCount(queryParams, sqlquery);
    }

    public int getDatasAllCount(Collection queryParams, String sqlquery) {
        QueryConditonDatakey qcdk = new QueryConditonDatakey(sqlquery, queryParams);
        return this.getDatasAllCount(qcdk);
    }

    public int getDatasAllCount(QueryConditonDatakey qcdk) {
        int allCountInt = 0;
        try {
            Integer allCount = this.blockCacheManager.getAllCountsFromCache(qcdk);
            if (allCount == null || !this.cacheEnable) {
                allCountInt = this.blockQueryJDBC.fetchDataAllCount(qcdk);
                if (this.cacheEnable && allCountInt != 0) {
                    this.blockCacheManager.saveAllCounts(qcdk, new Integer(allCountInt));
                }
            } else {
                allCountInt = allCount;
            }
        }
        catch (Exception e) {
            Debug.logError((String)(" getDatasAllCount error:" + e), (String)module);
        }
        return allCountInt;
    }

    public void clearCache() {
        Debug.logVerbose((String)"[JdonFramework] clear the cache for the batch inquiry!", (String)module);
        this.blockCacheManager.clearCache();
    }

    public void setPageIteratorJDBC(BlockQueryJDBC pageIteratorJDBC) {
        this.blockQueryJDBC = pageIteratorJDBC;
    }

    public BlockQueryJDBC getPageIteratorJDBC() {
        return this.blockQueryJDBC;
    }

    public boolean isCacheEnable() {
        return this.cacheEnable;
    }

    public void setCacheEnable(boolean cacheEnable) {
        this.cacheEnable = cacheEnable;
    }
}

