/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.model.query.block;

import com.jdon.model.query.block.Block;
import com.jdon.model.query.block.BlockQueryJDBC;
import com.jdon.model.query.cache.BlockCacheManager;
import com.jdon.model.query.cache.QueryConditonDatakey;
import com.jdon.util.Debug;
import java.util.Collection;
import java.util.List;

public class BlockStrategy {
    private static final String module = BlockStrategy.class.getName();
    private final BlockQueryJDBC blockQueryJDBC;
    private final BlockCacheManager blockCacheManager;
    private int blockLength = 200;

    public BlockStrategy(BlockQueryJDBC blockQueryJDBC, BlockCacheManager blockCacheManager) {
        this.blockQueryJDBC = blockQueryJDBC;
        this.blockCacheManager = blockCacheManager;
    }

    public Block locate(String sqlquery, Collection queryParams, Object locateId) {
        int blockSize = this.getBlockLength();
        Block block = null;
        int index = -1;
        int prevBlockStart = Integer.MIN_VALUE;
        int nextBlockStart = Integer.MIN_VALUE;
        int start = 0;
        Debug.logVerbose((String)("[JdonFramework]try to locate a block locateId= " + locateId + " blockSize=" + blockSize), (String)module);
        try {
            while (index == -1 && (block = this.getBlock(sqlquery, queryParams, start, blockSize)) != null) {
                List list = block.getList();
                index = list.indexOf(locateId);
                if (index >= 0 && index < list.size()) {
                    Debug.logVerbose((String)("[JdonFramework]found the locateId, index= " + index), (String)module);
                    if (index == 0 && block.getStart() >= blockSize) {
                        prevBlockStart = start - blockSize;
                        break;
                    }
                    if (index != blockSize - 1) break;
                    nextBlockStart = start + blockSize;
                    break;
                }
                if (block.getCount() < blockSize) break;
                start += blockSize;
            }
            if (index == -1) {
                Debug.logVerbose((String)("[JdonFramework] not locate the block that have the locateId= " + locateId), (String)module);
                return null;
            }
            if (prevBlockStart != Integer.MIN_VALUE) {
                Block prevBlock = this.getBlock(sqlquery, queryParams, prevBlockStart, blockSize);
                prevBlock.getList().addAll(block.getList());
                prevBlock.setStart(prevBlock.getStart() + prevBlock.getCount());
                prevBlock.setCount(prevBlock.getCount() + block.getCount());
                return prevBlock;
            }
            if (nextBlockStart != Integer.MIN_VALUE) {
                Block nextBlock = this.getBlock(sqlquery, queryParams, nextBlockStart, blockSize);
                if (nextBlock != null) {
                    block.getList().addAll(nextBlock.getList());
                    block.setCount(block.getCount() + nextBlock.getCount());
                }
                return block;
            }
            return block;
        }
        catch (Exception e) {
            Debug.logError((String)(" locate Block error" + e), (String)module);
            return block;
        }
    }

    public Block getBlock(String sqlquery, Collection queryParams, int startIndex, int count) {
        QueryConditonDatakey qcdk;
        Block block;
        Debug.logVerbose((String)"[JdonFramework]enter getBlock .. ", (String)module);
        if (count > this.blockLength || count <= 0) {
            count = this.blockLength;
        }
        if ((block = this.getBlock(qcdk = new QueryConditonDatakey(sqlquery, queryParams, startIndex, count, this.blockLength))).getCount() > 0) {
            Debug.logVerbose((String)("[JdonFramework]got a Block" + block.getCount()), (String)module);
            return block;
        }
        Debug.logVerbose((String)"[JdonFramework]not found the block!", (String)module);
        return null;
    }

    private Block getBlock(QueryConditonDatakey qcdk) {
        Block clientBlock = new Block(qcdk.getStart(), qcdk.getCount());
        if (clientBlock.getCount() > this.blockLength) {
            clientBlock.setCount(this.blockLength);
        }
        List list = this.getBlockKeys(qcdk);
        Block dataBlock = new Block(qcdk.getBlockStart(), list.size());
        int currentStart = clientBlock.getStart() - dataBlock.getStart();
        Block currentBlock = new Block(currentStart, clientBlock.getCount());
        currentBlock.setList(list);
        try {
            int lastCount = dataBlock.getCount() + dataBlock.getStart() - clientBlock.getStart();
            Debug.logVerbose((String)("[JdonFramework] lastCount=" + lastCount), (String)module);
            if (lastCount < clientBlock.getCount()) {
                if (dataBlock.getCount() == this.blockLength) {
                    int newStartIndex = dataBlock.getStart() + dataBlock.getCount();
                    int newCount = clientBlock.getCount() - lastCount;
                    qcdk.setStart(newStartIndex);
                    qcdk.setCount(newCount);
                    Debug.logVerbose((String)("[JdonFramework]  newStartIndex=" + newStartIndex + " newCount=" + newCount), (String)module);
                    Block nextBlock = this.getBlock(qcdk);
                    Debug.logVerbose((String)("[JdonFramework]  nextBlock.getCount()=" + nextBlock.getCount()), (String)module);
                    currentBlock.setCount(currentBlock.getCount() + nextBlock.getCount());
                } else {
                    currentBlock.setCount(lastCount);
                }
            }
        }
        catch (Exception e) {
            Debug.logError((String)(" getBlock error" + e), (String)module);
        }
        return currentBlock;
    }

    private List getBlockKeys(QueryConditonDatakey qcdk) {
        List keys = this.blockCacheManager.getBlockKeysFromCache(qcdk);
        if (keys == null) {
            keys = this.blockQueryJDBC.fetchDatas(qcdk);
            this.blockCacheManager.saveBlockKeys(qcdk, keys);
        }
        Debug.logVerbose((String)("[JdonFramework] getBlockKeys, size=" + keys.size()), (String)module);
        return keys;
    }

    public int getBlockLength() {
        return this.blockLength;
    }

    public void setBlockLength(int blockLength) {
        this.blockLength = blockLength;
    }
}

