/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.model.query.cache;

import com.jdon.controller.cache.CacheKey;
import com.jdon.controller.cache.CacheManager;
import com.jdon.controller.cache.StringKey;
import com.jdon.model.cache.BlockCacheKeyFactory;
import com.jdon.model.query.cache.QueryConditonDatakey;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class BlockCacheManager {
    private static final Logger logger = Logger.getLogger(BlockCacheManager.class);
    public static final String CACHE_TYPE_BLOCK = "BLOCK";
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final CacheManager cacheManager;
    private final List<CacheKey> cacheKeys = new CopyOnWriteArrayList<CacheKey>();
    private final BlockCacheKeyFactory blockCacheKeyFactory;

    public BlockCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.blockCacheKeyFactory = new BlockCacheKeyFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBlockKeysFromCache(QueryConditonDatakey qckey) {
        this.lock.readLock().lock();
        try {
            CacheKey cacheKey = this.blockCacheKeyFactory.createCacheKey(qckey.getBlockDataKey(), qckey.getSQlKey());
            List list = (List)this.cacheManager.fetchObject((StringKey)cacheKey);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBlockKeys(QueryConditonDatakey qckey, List keys) {
        this.lock.writeLock().lock();
        try {
            CacheKey cacheKey = this.blockCacheKeyFactory.createCacheKey(qckey.getBlockDataKey(), qckey.getSQlKey());
            this.cacheManager.putObect(cacheKey, (Object)keys);
            this.cacheKeys.add(cacheKey);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getAllCountsFromCache(QueryConditonDatakey qckey) {
        this.lock.readLock().lock();
        try {
            CacheKey cacheKey = this.blockCacheKeyFactory.createCacheKey(qckey.getBlockDataKey(), qckey.getSQlKey());
            Integer n = (Integer)this.cacheManager.fetchObject((StringKey)cacheKey);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAllCounts(QueryConditonDatakey qckey, Integer allCount) {
        this.lock.writeLock().lock();
        try {
            CacheKey cacheKey = this.blockCacheKeyFactory.createCacheKey(qckey.getBlockDataKey(), qckey.getSQlKey());
            this.cacheManager.putObect(cacheKey, (Object)allCount);
            this.cacheKeys.add(cacheKey);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.cacheKeys == null || this.cacheManager == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            Object[] keys = this.cacheKeys.toArray();
            this.cacheKeys.clear();
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] == null) continue;
                try {
                    CacheKey cacheKey = (CacheKey)keys[i];
                    this.cacheManager.removeObect((StringKey)cacheKey);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

