/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.aop.interceptor;

import com.jdon.controller.model.ModelUtil;
import com.jdon.domain.advsior.ModelAdvisor;
import com.jdon.domain.model.cache.ModelKey;
import com.jdon.domain.model.cache.ModelManager;
import com.jdon.domain.model.injection.ModelProxyInjection;
import com.jdon.util.Debug;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class CacheInterceptor
implements MethodInterceptor {
    private static final String module = CacheInterceptor.class.getName();
    private final ModelManager modelManager;
    private final ModelProxyInjection modelProxyInjection;
    private final ModelAdvisor modelAdvisor;
    public final String match_MethodName = "get";
    private final List isModelCache = new ArrayList();

    public CacheInterceptor(ModelManager modelManager, ModelProxyInjection modelProxyInjection, ModelAdvisor modelAdvisor) {
        this.modelManager = modelManager;
        this.modelProxyInjection = modelProxyInjection;
        this.modelAdvisor = modelAdvisor;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!this.methodMatchsModelGET(method)) {
            return invocation.proceed();
        }
        Debug.logVerbose("[JdonFramework] enter cacheInteceptor method:" + method.getName(), module);
        Class<?> modelClass = method.getReturnType();
        try {
            String dataKey = this.getArguments(invocation);
            if (dataKey == null) {
                return invocation.proceed();
            }
            ModelKey modelKey = new ModelKey((Object)dataKey, modelClass);
            Object model = this.modelManager.getCache(modelKey);
            if (model == null) {
                model = invocation.proceed();
                if (modelClass.isAssignableFrom(model.getClass())) {
                    this.modelProxyInjection.injectProperties(model);
                    model = this.modelAdvisor.createProxy(model);
                }
                Debug.logVerbose("[JdonFramework] save to cache", module);
                this.modelManager.addCache(modelKey, model);
            }
            return model;
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework]CacheInterceptor Exception error:" + e, module);
            return invocation.proceed();
        }
    }

    private boolean methodMatchsModelGET(Method method) {
        boolean condition = false;
        try {
            if (this.isModelCache.contains(method)) {
                condition = true;
                return condition;
            }
            String mehtodName = method.getName();
            if (method.getReturnType() == null) {
                return condition;
            }
            Class<?> returnClass = method.getReturnType();
            if (returnClass.getSuperclass() == null) {
                return condition;
            }
            Debug.logVerbose("[JdonFramework]methodMatchsModelGET: returnClassName = " + returnClass.getName(), module);
            if (ModelUtil.isModel(returnClass) && mehtodName.indexOf("get") != -1) {
                condition = true;
                this.isModelCache.add(method);
            }
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework]Exception error:" + ex, module);
        }
        catch (Throwable the) {
            Debug.logError("[JdonFramework]Throwable error:" + the, module);
        }
        return condition;
    }

    public String getArguments(MethodInvocation invocation) {
        try {
            Object[] args = invocation.getArguments();
            if (args == null) {
                return null;
            }
            if (args.length != 1) {
                return null;
            }
            if (args[0] == null) {
                return null;
            }
            return args[0].toString();
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] method:" + invocation.getMethod().getName() + "  " + ex, module);
            return null;
        }
    }

    public String getMatch_MethodName() {
        return "get";
    }
}

