/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.aop.interceptor;

import com.jdon.aop.reflection.ProxyMethodInvocation;
import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.bussinessproxy.target.TargetServiceFactory;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.access.TargetMetaRequestsHolder;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.controller.cache.InstanceCache;
import com.jdon.controller.pool.CommonsPoolAdapter;
import com.jdon.controller.pool.CommonsPoolFactory;
import com.jdon.controller.pool.PoolConfigure;
import com.jdon.controller.pool.Poolable;
import com.jdon.util.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class PoolInterceptor
implements MethodInterceptor {
    private static final String module = PoolInterceptor.class.getName();
    private final Map poolFactorys;
    private final TargetServiceFactory targetServiceFactory;
    private final ContainerCallback containerCallback;
    private final PoolConfigure poolConfigure;
    private final List isPoolableCache = new ArrayList();
    private final List unPoolableCache = new ArrayList();
    private final TargetMetaRequestsHolder targetMetaRequestsHolder;

    public PoolInterceptor(TargetServiceFactory targetServiceFactory, TargetMetaRequestsHolder targetMetaRequestsHolder, ContainerCallback containerCallback, PoolConfigure poolConfigure) {
        this.targetServiceFactory = targetServiceFactory;
        this.targetMetaRequestsHolder = targetMetaRequestsHolder;
        this.containerCallback = containerCallback;
        this.poolConfigure = poolConfigure;
        this.poolFactorys = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        ProxyMethodInvocation proxyMethodInvocation = (ProxyMethodInvocation)invocation;
        TargetMetaDef targetMetaDef = this.targetMetaRequestsHolder.getTargetMetaRequest().getTargetMetaDef();
        if (targetMetaDef.isEJB()) {
            return invocation.proceed();
        }
        if (!this.isPoolabe(targetMetaDef)) {
            return invocation.proceed();
        }
        Debug.logVerbose("[JdonFramework] enter PoolInterceptor", module);
        CommonsPoolFactory commonsPoolFactory = (CommonsPoolFactory)this.poolFactorys.get(targetMetaDef.getCacheKey());
        if (commonsPoolFactory == null) {
            commonsPoolFactory = this.getCommonsPoolFactory(targetMetaDef);
            this.poolFactorys.put(targetMetaDef.getCacheKey(), commonsPoolFactory);
        }
        CommonsPoolAdapter pool = commonsPoolFactory.getPool();
        Object poa = null;
        Object result = null;
        try {
            poa = pool.acquirePoolable();
            Debug.logVerbose("[JdonFramework] borrow a object:" + targetMetaDef.getClassName() + " id:" + poa.hashCode() + " from pool", module);
            Debug.logVerbose("[JdonFramework]pool state: active=" + pool.getNumActive() + " free=" + pool.getNumIdle(), module);
            proxyMethodInvocation.setThis(poa);
            result = invocation.proceed();
        }
        catch (Exception ex) {
            Debug.logError(ex, module);
        }
        finally {
            if (poa != null) {
                pool.releasePoolable(poa);
                Debug.logVerbose("[JdonFramework] realease a object:" + targetMetaDef.getClassName() + " to pool", module);
            }
        }
        return result;
    }

    private CommonsPoolFactory getCommonsPoolFactory(TargetMetaDef targetMetaDef) {
        CommonsPoolFactory commonsPoolFactory = null;
        try {
            ContainerWrapper containerWrapper = this.containerCallback.getContainerWrapper();
            InstanceCache instanceCache = (InstanceCache)containerWrapper.lookup("instanceCache");
            String key = targetMetaDef.getCacheKey() + " CommonsPoolFactory";
            commonsPoolFactory = (CommonsPoolFactory)instanceCache.get(key);
            if (commonsPoolFactory == null) {
                Debug.logVerbose("[JdonFramework] first time call commonsPoolFactory\uff0c create it:" + key, module);
                commonsPoolFactory = new CommonsPoolFactory(this.targetServiceFactory, this.poolConfigure.getMaxPoolSize());
                instanceCache.put(key, commonsPoolFactory);
            }
        }
        catch (Exception ex) {
            Debug.logError(ex, module);
        }
        return commonsPoolFactory;
    }

    public boolean isPoolabe(TargetMetaDef targetMetaDef) {
        boolean found = false;
        if (this.isPoolableCache.contains(targetMetaDef.getName())) {
            found = true;
        } else if (!this.unPoolableCache.contains(targetMetaDef.getName())) {
            Debug.logVerbose("[JdonFramework] check if it is a Poolable", module);
            ContainerWrapper containerWrapper = this.containerCallback.getContainerWrapper();
            Class thisCLass = containerWrapper.getComponentClass(targetMetaDef.getName());
            if (Poolable.class.isAssignableFrom(thisCLass) || thisCLass.isAnnotationPresent(com.jdon.annotation.intercept.Poolable.class)) {
                found = true;
                this.isPoolableCache.add(targetMetaDef.getName());
            } else {
                this.unPoolableCache.add(targetMetaDef.getName());
            }
        }
        return found;
    }
}

